/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.tee;

import android.content.Context;
import com.transsion.security.api.hap.TranCryptoManagerLite;
import com.transsion.security.api.hap.TranStoreManagerLite;
import com.transsion.xuanniao.account.comm.tee.IStoreManager;
import com.transsion.xuanniao.account.comm.tee.LiteKeyManager;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import hyperion.hap.ICryptoManager;

public class LiteTeeStoreManager
implements IStoreManager {
    private final Context context;

    public LiteTeeStoreManager(Context ctx) {
        this.context = ctx;
    }

    @Override
    public void saveString(String key, String value) {
        this.getStoreManager(this.context).saveString(key, value);
    }

    @Override
    public void saveStringPersist(String key, String value) {
        this.getStoreManager(this.context).saveStringPersist(key, value);
    }

    @Override
    public String loadString(String key) {
        return this.getStoreManager(this.context).loadString(key);
    }

    @Override
    public String sign(Context context, byte[] value) {
        byte[] sign = this.getCryptoManager(context).sign(LiteKeyManager.instance().signatureAlias, value);
        if (sign != null) {
            return RSAEncryptUtil.base64Encode(sign);
        }
        return "";
    }

    @Override
    public String genKeyId(Context context) {
        return LiteKeyManager.instance().genKeyId(context);
    }

    @Override
    public String exportSignatureKey(Context context) {
        return LiteKeyManager.instance().exportSignatureKey(context);
    }

    private ICryptoManager getCryptoManager(Context context) {
        return (ICryptoManager)TranCryptoManagerLite.Companion.getInstance((Object)context.getApplicationContext());
    }

    private hyperion.hap.IStoreManager getStoreManager(Context context) {
        return (hyperion.hap.IStoreManager)TranStoreManagerLite.Companion.getInstance((Object)context.getApplicationContext());
    }
}

