/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.tee;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.transsion.palmsdk.PalmID;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.tee.IStoreManager;
import com.transsion.xuanniao.account.comm.tee.LiteTeeStoreManager;
import com.transsion.xuanniao.account.model.data.AccountRes;
import com.transsion.xuanniao.account.model.data.Config;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class TeeManager {
    private final String KEY_ACCOUNT = "account";
    private final String KEY_OTHER_OPEN_ID = "other_open_id";
    private final String KEY_CONFIG = "config";
    private final String KEY_IS_KEY_UPLOADED = "isKeyUploaded";
    private final String KEY_FINGERPRINT = "fingerprint";
    private CipherHelper cipherHelper;
    private IStoreManager storeManager;
    private boolean isTeeEnable = false;

    private TeeManager() {
        Context context = PalmID.getContext();
        if (context != null) {
            this.storeManager = new LiteTeeStoreManager(context);
            this.isTeeEnable = true;
        }
    }

    public void setStoreManager(IStoreManager manager) {
        this.storeManager = manager;
    }

    public void setTeeEnable(boolean enable) {
        this.isTeeEnable = enable;
    }

    public boolean isTeeEnable() {
        return this.isTeeEnable;
    }

    public CipherHelper generateCipher() {
        if (this.cipherHelper == null) {
            byte[] iv = new byte[16];
            SecureRandom sRandom = new SecureRandom();
            sRandom.nextBytes(iv);
            this.cipherHelper = new CipherHelper("AES/CBC/PKCS5Padding", this.generateKey(), iv);
        }
        return this.cipherHelper;
    }

    public byte[] generateKey() {
        try {
            SecretKey secretKey = KeyGenerator.getInstance("AES").generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clearAccount(Context context) {
        if (this.storeManager != null) {
            this.storeManager.saveString("account", "");
        }
    }

    public static TeeManager instance() {
        return SingletonInnerHolder.instance;
    }

    public void saveAccountInfo(AccountRes accountRes) {
        if (accountRes != null && this.storeManager != null) {
            this.storeManager.saveString("account", new Gson().toJson((Object)accountRes));
        }
    }

    public AccountRes getAccountInfo() {
        String account;
        if (this.storeManager != null && !TextUtils.isEmpty((CharSequence)(account = this.storeManager.loadString("account")))) {
            AccountRes accountRes = (AccountRes)new Gson().fromJson(account, AccountRes.class);
            return accountRes;
        }
        return null;
    }

    public String getOtherOpenId() {
        String otherOpenId;
        if (this.storeManager != null && !TextUtils.isEmpty((CharSequence)(otherOpenId = this.storeManager.loadString("other_open_id")))) {
            return otherOpenId;
        }
        return "0";
    }

    public void saveOtherOpenId(String openId) {
        if (!TextUtils.isEmpty((CharSequence)openId)) {
            this.storeManager.saveString("other_open_id", openId);
        }
    }

    public void saveToken(String token, String refreshToken) {
        Config config = this.getConfig();
        if (config == null) {
            config = new Config();
        }
        config.token = token;
        config.refreshToken = refreshToken;
        if (this.storeManager != null) {
            this.storeManager.saveString("config", new Gson().toJson((Object)config));
        }
    }

    public String getToken() {
        Config config = this.getConfig();
        if (config != null) {
            return config.token;
        }
        return "";
    }

    public String getRefreshToken() {
        Config config = this.getConfig();
        if (config != null) {
            return config.refreshToken;
        }
        return "";
    }

    public void saveKeyUploaded(boolean isKeyUploaded) {
        if (this.storeManager != null) {
            this.storeManager.saveString("isKeyUploaded", isKeyUploaded ? "true" : "false");
        }
    }

    public Config getConfig() {
        String data;
        if (this.storeManager != null && !TextUtils.isEmpty((CharSequence)(data = this.storeManager.loadString("config")))) {
            return (Config)new Gson().fromJson(data, Config.class);
        }
        return null;
    }

    public void saveFingerprint(Context context, String fingerprint) {
        if (this.storeManager != null) {
            this.storeManager.saveString("fingerprint", fingerprint);
        }
    }

    public String getFingerprint(Context context) {
        if (this.storeManager != null) {
            return this.storeManager.loadString("fingerprint");
        }
        return "";
    }

    public boolean getIsKeyUploaded() {
        Config config = this.getConfig();
        if (config != null) {
            return config.isKeyUploaded || "true".equals(this.storeManager.loadString("isKeyUploaded"));
        }
        if (this.storeManager != null) {
            return "true".equals(this.storeManager.loadString("isKeyUploaded"));
        }
        return false;
    }

    public String getLinkedBrandId() {
        String linkedBrandId = null;
        if (this.storeManager != null) {
            linkedBrandId = this.storeManager.loadString("linked_bd");
        }
        return linkedBrandId;
    }

    public String sign(Context context, byte[] value) {
        if (this.storeManager != null) {
            return this.storeManager.sign(context, value);
        }
        return "";
    }

    public String genKeyId(Context context) {
        if (this.storeManager != null) {
            return this.storeManager.genKeyId(context);
        }
        return "";
    }

    public String exportSignatureKey(Context context) {
        if (this.storeManager != null) {
            return this.storeManager.exportSignatureKey(context);
        }
        return null;
    }

    static class SingletonInnerHolder {
        static TeeManager instance = new TeeManager();

        SingletonInnerHolder() {
        }
    }
}

