/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Log;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

public class AppUtils {
    public static String getVerName(Context context) {
        String verName = "";
        try {
            verName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return verName;
    }

    public static String getSHA1Fingerprint(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        int flags = 64;
        PackageInfo packageInfo = null;
        try {
            packageInfo = pm.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (packageInfo == null) {
            Log.d((String)"AidlUtil", (String)("\u4fe1\u606f\u4e3a null, \u5305\u540d = " + packageName));
            return "";
        }
        Signature[] signatures = packageInfo.signatures;
        byte[] cert = signatures[0].toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(cert);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        X509Certificate c = null;
        try {
            c = (X509Certificate)cf.generateCertificate(input);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        String hexString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(c.getEncoded());
            hexString = AppUtils.byte2HexFormatted(publicKey);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        return hexString;
    }

    private static String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1) {
                h = "0" + h;
            }
            if (l > 2) {
                h = h.substring(l - 2, l);
            }
            str.append(h.toUpperCase());
            if (i >= arr.length - 1) continue;
            str.append(':');
        }
        return str.toString();
    }

    public static void setWindowSecure(Activity activity, boolean isSecure) {
        if (isSecure) {
            if ((activity.getWindow().getAttributes().flags & 0x2000) != 0) {
                return;
            }
            activity.getWindow().addFlags(8192);
        } else {
            if ((activity.getWindow().getAttributes().flags & 0x2000) == 0) {
                return;
            }
            activity.getWindow().clearFlags(8192);
        }
    }

    public static boolean isActionSupport(Context context, String action) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent(action);
            List resolveInfo = packageManager.queryIntentActivities(intent, 65536);
            return resolveInfo.size() > 0;
        }
        catch (Exception e) {
            LogUtils.d(Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getAppSignMD5(Context context) {
        try {
            Signature[] signatureArray;
            int n;
            int n2;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            Signature[] signatures = packageInfo.signatures;
            if (signatures != null && (n2 = 0) < (n = (signatureArray = signatures).length)) {
                Signature signature = signatureArray[n2];
                byte[] digestBytes = digest.digest(signature.toByteArray());
                StringBuilder builder = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    builder.append(Integer.toHexString(digestByte & 0xFF | 0x100).substring(1, 3));
                }
                return builder.toString().toUpperCase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static boolean isSystemApp(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.uid == 1000 || (ai.flags & 1) != 0;
    }
}

