/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Base64;
import com.transsion.xuanniao.account.comm.net.GlobalHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;

public class BitmapUtils {
    public static Bitmap decodeFile(String path, int maxWidth, int maxHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap scanBitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        int scale = 1;
        for (int i = 0; i < Integer.MAX_VALUE && (options.outWidth / scale > maxWidth && (double)(options.outWidth / scale) > (double)maxWidth * 1.4 || options.outHeight / scale > maxHeight && (double)(options.outHeight / scale) > (double)maxHeight * 1.4); ++i) {
            ++scale;
        }
        options.inSampleSize = scale;
        options.inJustDecodeBounds = false;
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap decodeFile(String path) {
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static void saveBitmapPng(String path, Bitmap bitmap) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        } else {
            file.mkdirs();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out)) {
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap base64ToBitmap(String base64) {
        if (TextUtils.isEmpty((CharSequence)base64)) {
            return null;
        }
        byte[] bytes = Base64.decode((String)base64, (int)0);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap getPic(String url) {
        try {
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url(url).build();
            ResponseBody body = client.newCall(request).execute().body();
            InputStream in = body.byteStream();
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
            return bitmap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveBitmap(final String url, final String path, final SaveBitmap saveBitmap) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = BitmapUtils.getPic(url);
                if (bitmap != null) {
                    BitmapUtils.saveBitmapPng(path, bitmap);
                }
                GlobalHandler.getInstance().runInMain(new Runnable(){

                    @Override
                    public void run() {
                        if (saveBitmap != null) {
                            saveBitmap.onFinish(path);
                        }
                    }
                });
            }
        }).start();
    }

    public static interface SaveBitmap {
        public void onFinish(String var1);
    }
}

