/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.utils;

import android.text.TextUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatUtil {
    public static String markPhone(String phone) {
        try {
            if (phone == null || "".equals(phone)) {
                return "";
            }
            if (phone.contains("-")) {
                String[] ss = phone.split("-");
                if (ss[1].length() < 6) {
                    return "+" + ss[0] + " " + ss[1];
                }
                return "+" + ss[0] + " " + ss[1].substring(0, 3) + "***" + ss[1].substring(ss[1].length() - 2);
            }
            if (phone.length() < 6) {
                return phone;
            }
            return phone.substring(0, 3) + "***" + phone.substring(phone.length() - 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return phone;
        }
    }

    public static String phone(String phone) {
        try {
            if (phone == null || "".equals(phone)) {
                return "";
            }
            if (phone.contains("-")) {
                String[] ss = phone.split("-");
                return "+" + ss[0] + " " + ss[1];
            }
            return phone;
        }
        catch (Exception e) {
            e.printStackTrace();
            return phone;
        }
    }

    public static String markEmail(String email) {
        try {
            if (email == null || "".equals(email) || email.indexOf("@") <= 0) {
                return "";
            }
            String[] ss = email.split("@");
            if (ss[0].length() < 3) {
                return ss[0].charAt(0) + "***" + ss[1];
            }
            return ss[0].substring(0, 3) + "***@" + ss[1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return email;
        }
    }

    public static boolean checkEmail(String email) {
        String emailRule = "^([A-Za-z0-9_\\-.])+@([A-Za-z0-9_\\-])+\\.(([A-Za-z])+\\.)?([A-Za-z]{2,6})$";
        return email.matches(emailRule);
    }

    public static boolean checkPhone(String phone) {
        String phoneRule = "^[0-9]{6,15}$";
        return phone.matches(phoneRule);
    }

    public static int checkPwd(String pwd) {
        if (TextUtils.isEmpty((CharSequence)pwd) || pwd.length() < 4 || pwd.length() > 16) {
            return 0;
        }
        return -1;
    }

    private static boolean containsSpecialCharacters(String[] characters, String value) {
        for (int i = 0; i < characters.length; ++i) {
            if (!value.contains(characters[i])) continue;
            return true;
        }
        return false;
    }

    public static int checkAccountId(String accountId) {
        if (TextUtils.isEmpty((CharSequence)accountId) || accountId.length() < 6 || accountId.length() > 50) {
            return 1;
        }
        if (!FormatUtil.find("[a-z]", accountId) && !FormatUtil.find("[A-Z]", accountId)) {
            return 2;
        }
        boolean isRepeatFlag = true;
        boolean isConsequent = true;
        for (int i = 0; i < accountId.length() - 1; ++i) {
            int gap = accountId.charAt(i + 1) - accountId.charAt(i);
            if (gap != 0) {
                isRepeatFlag = false;
            }
            if (gap == 1) continue;
            isConsequent = false;
        }
        if (isRepeatFlag) {
            return 3;
        }
        if (isConsequent) {
            return 4;
        }
        return -1;
    }

    private static boolean accountIdFormat(String accountId) {
        return accountId.matches("^(?=.*[a-zA-Z])[0-9a-zA-Z_]{6,25}$");
    }

    private static boolean find(String rule, String value) {
        Pattern pattern = Pattern.compile(rule);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static String stampToDate(long stamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(stamp);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static boolean isNotEmpty(String value) {
        return value != null && !"".equals(value);
    }

    public static String millisToM(long millisUntilFinished) {
        if (millisUntilFinished > 0L) {
            long second = millisUntilFinished / 1000L;
            long minute = second / 60L;
            long remainder = second % 60L;
            StringBuilder builder = new StringBuilder();
            if (minute < 10L) {
                builder.append("0");
            }
            builder.append(minute).append(":");
            if (remainder < 10L) {
                builder.append("0");
            }
            builder.append(remainder);
            return builder.toString();
        }
        return "";
    }

    public static String timestampToTime(long timestamp) {
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).format(new Date(timestamp));
        return time;
    }
}

