/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.BitmapUtils;
import com.transsion.xuanniao.account.comm.widget.CustomClickListener;

public class CaptchaCodeInput
extends FrameLayout {
    private EditText edit;
    private ImageView captcha;
    private ICaptchaListener captchaListener;
    private String captchaBase64;

    public CaptchaCodeInput(Context context) {
        super(context);
    }

    public CaptchaCodeInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.xn_view_captcha_input, (ViewGroup)this, true);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        this.initView();
    }

    private void initAttr(TypedArray array) {
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = this.findViewById(R.id.line);
        lineView.setVisibility(showLine ? 0 : 4);
        if (hint != null && !hint.isEmpty()) {
            EditText phoneEdit = (EditText)this.findViewById(R.id.edit);
            phoneEdit.setHint((CharSequence)hint);
        }
        array.recycle();
    }

    private void initView() {
        this.edit = (EditText)this.findViewById(R.id.edit);
        this.captcha = (ImageView)this.findViewById(R.id.captcha);
        this.captcha.setOnClickListener((View.OnClickListener)new Click());
        this.edit.setOnFocusChangeListener((View.OnFocusChangeListener)new FocusListener());
        if (this.getContext().getResources().getConfiguration().getLayoutDirection() == 1) {
            this.captcha.setScaleType(ImageView.ScaleType.FIT_START);
        } else {
            this.captcha.setScaleType(ImageView.ScaleType.FIT_END);
        }
    }

    public String getText() {
        return this.edit.getText().toString();
    }

    public void setText(String value) {
        this.edit.setText((CharSequence)value);
    }

    public void addWatch(TextWatcher watcher) {
        this.edit.addTextChangedListener(watcher);
    }

    public ICaptchaListener getCaptchaListener() {
        return this.captchaListener;
    }

    public void setCaptchaListener(ICaptchaListener captchaListener) {
        this.captchaListener = captchaListener;
    }

    public void setImageBitmap(String captchaBase64) {
        this.captchaBase64 = captchaBase64;
        this.captcha.setImageBitmap(BitmapUtils.base64ToBitmap(captchaBase64));
    }

    public void setImageResource(int id2) {
        this.captcha.setImageResource(id2);
    }

    public EditText getEdit() {
        return this.edit;
    }

    public void setError(boolean error) {
        View line = this.findViewById(R.id.line);
        if (error) {
            line.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_red_basic_color));
        } else {
            line.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_gray_secondary_color));
        }
    }

    public void saveState(Bundle outState) {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            outState.putString("cc_text", this.getText());
        }
        if (!TextUtils.isEmpty((CharSequence)this.captchaBase64)) {
            outState.putString("cc_captcha", this.captchaBase64);
        }
        outState.putInt("cc_visibility", this.getVisibility());
    }

    public void restoreState(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey("cc_text")) {
                this.setText(inState.getString("cc_text"));
            }
            if (inState.containsKey("cc_captcha")) {
                this.setImageBitmap(inState.getString("cc_captcha"));
            }
            if (inState.containsKey("cc_visibility")) {
                this.setVisibility(inState.getInt("cc_visibility"));
            }
        }
    }

    public static interface ICaptchaListener {
        public void onClick();
    }

    class Click
    extends CustomClickListener {
        Click() {
        }

        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.captcha && CaptchaCodeInput.this.captchaListener != null) {
                CaptchaCodeInput.this.captchaListener.onClick();
            }
        }
    }

    class FocusListener
    implements View.OnFocusChangeListener {
        FocusListener() {
        }

        public void onFocusChange(View v, boolean hasFocus) {
            View line = CaptchaCodeInput.this.findViewById(R.id.line);
            int colorId = hasFocus ? R.color.xn_line_s : R.color.os_gray_secondary_color;
            line.setBackgroundColor(CaptchaCodeInput.this.getResources().getColor(colorId));
            AppCompatImageView captchaLogo = (AppCompatImageView)CaptchaCodeInput.this.findViewById(R.id.captchaLogo);
            Drawable drawable2 = captchaLogo.getDrawable();
            drawable2.setTint(CaptchaCodeInput.this.getResources().getColor(hasFocus ? R.color.xn_input_logo_color_s : R.color.xn_input_logo_color, null));
        }
    }
}

