/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.BidiFormatter;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.transsion.core.utils.ScreenUtil;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.widget.CustomClickListener;

public class PhoneInput
extends FrameLayout {
    private EditText edit;
    private TextView cc;
    private IPhoneInputListener inputListener;
    private EditFocus editFocus;
    private BidiFormatter bidiFormatter;

    public PhoneInput(Context context) {
        super(context);
    }

    public PhoneInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.xn_phone_input, (ViewGroup)this, true);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        this.initView();
    }

    private void initAttr(TypedArray array) {
        int maxLength;
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = this.findViewById(R.id.line);
        lineView.setVisibility(showLine ? 0 : 4);
        this.edit = (EditText)this.findViewById(R.id.edit);
        if (hint != null && !hint.isEmpty()) {
            this.edit.setHint((CharSequence)hint);
        }
        if ((maxLength = array.getInteger(R.styleable.InputView_max_length, -1)) >= 0) {
            this.edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
        array.recycle();
    }

    private void initView() {
        this.bidiFormatter = BidiFormatter.getInstance();
        this.edit = (EditText)this.findViewById(R.id.edit);
        this.edit.addTextChangedListener((TextWatcher)new Watch());
        this.cc = (TextView)this.findViewById(R.id.cc);
        this.cc.setOnClickListener((View.OnClickListener)new Click());
        this.edit.setOnFocusChangeListener((View.OnFocusChangeListener)new FocusListener());
    }

    public String getText() {
        return this.edit.getText().toString();
    }

    public void setCc(String text) {
        this.cc.setText((CharSequence)this.bidiFormatter.unicodeWrap(text, TextDirectionHeuristics.LTR));
        if (TextUtils.isEmpty((CharSequence)text) || TextUtils.isEmpty((CharSequence)text.trim())) {
            return;
        }
        switch (text.trim().length()) {
            case 2: {
                this.cc.setPadding(ScreenUtil.dip2px((float)16.0f), 0, ScreenUtil.dip2px((float)10.0f), 0);
                break;
            }
            case 3: {
                this.cc.setPadding(ScreenUtil.dip2px((float)10.0f), 0, ScreenUtil.dip2px((float)8.0f), 0);
                break;
            }
            case 4: {
                this.cc.setPadding(ScreenUtil.dip2px((float)5.0f), 0, ScreenUtil.dip2px((float)4.0f), 0);
                break;
            }
            case 5: {
                this.cc.setPadding(ScreenUtil.dip2px((float)1.0f), 0, ScreenUtil.dip2px((float)0.0f), 0);
            }
        }
    }

    public String getCc() {
        return this.cc.getText().toString();
    }

    public void setText(String text) {
        this.edit.setText((CharSequence)text);
        Editable b = this.edit.getText();
        this.edit.setSelection(b.length());
    }

    public void setPhoneAndCC(String value) {
        String[] ss;
        if (value != null && value.contains("-") && (ss = value.split("-")).length == 2) {
            this.setText(ss[1]);
            this.setCc("+" + ss[0]);
        }
    }

    public void addWatch(TextWatcher watcher) {
        this.edit.addTextChangedListener(watcher);
    }

    public void setInputListener(IPhoneInputListener inputListener) {
        this.inputListener = inputListener;
    }

    public void setEditFocus(EditFocus editFocus) {
        this.editFocus = editFocus;
    }

    public boolean haveFocus() {
        if (this.edit != null) {
            return this.edit.isFocusable();
        }
        return false;
    }

    public EditText getEdit() {
        return this.edit;
    }

    public static interface EditFocus {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface IPhoneInputListener {
        public void onSelectCc();
    }

    class Watch
    implements TextWatcher {
        Watch() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
        }
    }

    class Click
    extends CustomClickListener {
        Click() {
        }

        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.cc && PhoneInput.this.inputListener != null) {
                PhoneInput.this.inputListener.onSelectCc();
            }
        }
    }

    class FocusListener
    implements View.OnFocusChangeListener {
        FocusListener() {
        }

        public void onFocusChange(View v, boolean hasFocus) {
            View line = PhoneInput.this.findViewById(R.id.line);
            View ccLine = PhoneInput.this.findViewById(R.id.ccLine);
            int colorId = hasFocus ? R.color.xn_line_s : R.color.os_gray_secondary_color;
            line.setBackgroundColor(PhoneInput.this.getResources().getColor(colorId));
            ccLine.setBackgroundColor(PhoneInput.this.getResources().getColor(colorId));
            if (PhoneInput.this.editFocus != null) {
                PhoneInput.this.editFocus.onFocusChange(v, hasFocus);
            }
            PhoneInput.this.cc.setTextAppearance(hasFocus ? R.style.font_black_14 : R.style.font_black_14_t40);
        }
    }
}

