/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.CountDownTimer;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.widget.CustomClickListener;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;

public class SmsCodeInput
extends FrameLayout {
    private long millisInFuture = 100000L;
    private long countDownInterval = 1000L;
    private EditText smsEdit;
    private TextView getCode;
    private CountDownTimer countDownTimer;
    private ISmsCodeListener smsCodeListener;
    private boolean isCounting = false;
    private boolean isFirst = true;
    private EditFocus editFocus;

    public SmsCodeInput(Context context) {
        super(context);
    }

    public SmsCodeInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.xn_view_sms_input, (ViewGroup)this, true);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        this.millisInFuture = CloudConfigRes.getCount(context) * 1000;
        this.initView();
    }

    private void initAttr(TypedArray array) {
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = this.findViewById(R.id.smsLine);
        lineView.setVisibility(showLine ? 0 : 4);
        if (hint != null && !hint.isEmpty()) {
            EditText phoneEdit = (EditText)this.findViewById(R.id.edit);
            phoneEdit.setHint((CharSequence)hint);
        }
        array.recycle();
    }

    private void initView() {
        this.smsEdit = (EditText)this.findViewById(R.id.smsEdit);
        this.smsEdit.setOnFocusChangeListener((View.OnFocusChangeListener)new FocusListener());
        this.getCode = (TextView)this.findViewById(R.id.getCode);
        this.getCode.setOnClickListener((View.OnClickListener)new Click());
    }

    public String getText() {
        return this.smsEdit.getText().toString();
    }

    public void setText(String value) {
        this.smsEdit.setText((CharSequence)value);
    }

    public boolean isCounting() {
        return this.isCounting;
    }

    public void startCount() {
        this.isFirst = false;
        this.isCounting = true;
        this.smsEdit.requestFocus();
        if (this.countDownTimer == null) {
            this.countDownTimer = new CountDownTimer(this.millisInFuture, this.countDownInterval){

                @SuppressLint(value={"StringFormatInvalid"})
                public void onTick(long millisUntilFinished) {
                    SmsCodeInput.this.getCode.setText((CharSequence)SmsCodeInput.this.getContext().getString(R.string.xn_resend_code, new Object[]{millisUntilFinished / 1000L}));
                }

                public void onFinish() {
                    SmsCodeInput.this.isCounting = false;
                    if (SmsCodeInput.this.smsCodeListener != null) {
                        SmsCodeInput.this.smsCodeListener.countFinish();
                    }
                }
            };
        }
        this.countDownTimer.start();
    }

    private String second(long value) {
        return String.valueOf(value / 1000L);
    }

    public void startByEnd(long value) {
        if (value + this.millisInFuture > System.currentTimeMillis()) {
            this.setMillisInFuture(value + this.millisInFuture - System.currentTimeMillis());
            this.setGetCodeEnable(false);
            this.startCount();
        }
    }

    public void clearCount() {
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
            this.countDownTimer = null;
        }
        this.millisInFuture = CloudConfigRes.getCount(this.getContext()) * 1000;
    }

    public void setGetCodeEnable(boolean enable) {
        this.getCode.setEnabled(enable);
        if (enable) {
            this.setAppearance(this.getCode, R.style.font_get_code_medium);
            this.getCode.setText((CharSequence)this.getContext().getString(this.isFirst ? R.string.xn_get_code : R.string.xn_resend));
        } else {
            if (!this.isCounting) {
                this.getCode.setText((CharSequence)this.getContext().getString(this.isFirst ? R.string.xn_get_code : R.string.xn_resend));
            }
            this.setAppearance(this.getCode, R.style.font_get_code_disable_medium);
        }
    }

    public void warning(String text) {
        Toast toast = Toast.makeText((Context)this.getContext(), (CharSequence)text, (int)1);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    public void addWatch(TextWatcher watcher) {
        this.smsEdit.addTextChangedListener(watcher);
    }

    public long getMillisInFuture() {
        return this.millisInFuture;
    }

    public void setMillisInFuture(long millisInFuture) {
        this.millisInFuture = millisInFuture;
    }

    public long getCountDownInterval() {
        return this.countDownInterval;
    }

    public void setCountDownInterval(long countDownInterval) {
        this.countDownInterval = countDownInterval;
    }

    public void setSmsCodeListener(ISmsCodeListener smsCodeListener) {
        this.smsCodeListener = smsCodeListener;
    }

    public void setAppearance(TextView v, int styleId) {
        if (Build.VERSION.SDK_INT >= 23) {
            v.setTextAppearance(styleId);
        } else {
            v.setTextAppearance(this.getContext(), styleId);
        }
    }

    public EditFocus getEditFocus() {
        return this.editFocus;
    }

    public void setEditFocus(EditFocus editFocus) {
        this.editFocus = editFocus;
    }

    public EditText getEdit() {
        return this.smsEdit;
    }

    public void setError(boolean error) {
        View line = this.findViewById(R.id.smsLine);
        if (error) {
            line.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_red_basic_color));
        } else {
            line.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_gray_secondary_color));
        }
    }

    public static interface EditFocus {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface ISmsCodeListener {
        public void getCode();

        public void countFinish();
    }

    class FocusListener
    implements View.OnFocusChangeListener {
        FocusListener() {
        }

        public void onFocusChange(View v, boolean hasFocus) {
            View line = SmsCodeInput.this.findViewById(R.id.smsLine);
            int colorId = hasFocus ? R.color.xn_line_s : R.color.os_gray_secondary_color;
            line.setBackgroundColor(SmsCodeInput.this.getResources().getColor(colorId));
            AppCompatImageView smsLogo = (AppCompatImageView)SmsCodeInput.this.findViewById(R.id.smsLogo);
            Drawable drawable2 = smsLogo.getDrawable();
            drawable2.setTint(SmsCodeInput.this.getResources().getColor(hasFocus ? R.color.xn_input_logo_color_s : R.color.xn_input_logo_color, null));
            if (SmsCodeInput.this.editFocus != null) {
                SmsCodeInput.this.editFocus.onFocusChange(v, hasFocus);
            }
        }
    }

    class Click
    extends CustomClickListener {
        Click() {
        }

        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.getCode && SmsCodeInput.this.smsCodeListener != null) {
                SmsCodeInput.this.smsCodeListener.getCode();
            }
        }
    }
}

