/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.util.Utils;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.LogUtils;

public class XNLinkMovementMethod
extends LinkMovementMethod {
    private static LinkMovementMethod sInstance;

    public static LinkMovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new XNLinkMovementMethod();
        }
        return sInstance;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1 || action == 0 || action == 2 || action == 3) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout2 = widget.getLayout();
            int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
            ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            if (link.length != 0) {
                if (action == 1) {
                    link[0].onClick((View)widget);
                    this.cancelClickEffect(widget, buffer);
                } else if (action == 0 || action == 2) {
                    int color2 = 0;
                    try {
                        Context context = widget.getContext();
                        TypedValue typedValue = new TypedValue();
                        if (context.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
                            color2 = ContextCompat.getColor((Context)context, (int)typedValue.resourceId);
                        }
                    }
                    catch (Exception e) {
                        color2 = ContextCompat.getColor((Context)widget.getContext(), (int)R.color.xn_link_color_dis);
                    }
                    try {
                        buffer.setSpan((Object)new ForegroundColorSpan(color2), buffer.getSpanStart((Object)link[0]), buffer.getSpanEnd((Object)link[0]), 33);
                    }
                    catch (Exception e) {
                        LogUtils.d(Log.getStackTraceString((Throwable)e));
                    }
                } else {
                    this.cancelClickEffect(widget, buffer);
                }
                return true;
            }
            this.cancelClickEffect(widget, buffer);
        }
        return false;
    }

    private void cancelClickEffect(TextView widget, Spannable buffer) {
        ClickableSpan[] links = (ClickableSpan[])buffer.getSpans(0, buffer.length(), ClickableSpan.class);
        int color2 = 0;
        try {
            color2 = Utils.getOsPlatformBasicColor((Context)widget.getContext());
        }
        catch (Throwable e) {
            color2 = ContextCompat.getColor((Context)widget.getContext(), (int)R.color.xn_link_color);
        }
        try {
            for (int i = 0; i < links.length; ++i) {
                buffer.setSpan((Object)new ForegroundColorSpan(color2), buffer.getSpanStart((Object)links[i]), buffer.getSpanEnd((Object)links[i]), 33);
            }
        }
        catch (Exception e) {
            LogUtils.d(Log.getStackTraceString((Throwable)e));
        }
        Selection.removeSelection((Spannable)buffer);
    }
}

