/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.help.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ConsoleMessage;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.utils.AppUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.comm.widget.NoWifiPage;
import com.transsion.xuanniao.account.login.view.PrivacyNoNetDialog;
import tech.palm.lib.athena.AthenaImpl;

public class WebViewActivity
extends BaseActivity {
    private WebView mWebView;
    private PrivacyNoNetDialog noNetDialog;
    private String url;
    private ProgressBar mProgressBar;
    private NoWifiPage noWifiPage;

    public static void startActivity(Context context, int titleId, String url) {
        try {
            if (AppUtils.isSystemApp(context)) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                context.startActivity(intent);
            } else {
                Intent intent = new Intent(context, WebViewActivity.class);
                intent.putExtra("title", titleId);
                intent.putExtra("url", url);
                context.startActivity(intent);
            }
        }
        catch (Exception e) {
            LogUtils.d(Log.getStackTraceString((Throwable)e));
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.xn_activity_web_view);
        this.url = this.getIntent().getStringExtra("url");
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.initActionBar();
        this.initWebView();
    }

    protected void onResume() {
        super.onResume();
        this.showNoWifiPage();
    }

    private void showNoWifiPage() {
        if (!NetUtils.instance().isNetworkConnected((Context)this)) {
            if (this.noWifiPage == null) {
                this.noWifiPage = new NoWifiPage((Context)this);
                this.noWifiPage.setReload(new NoWifiPage.Reload(){

                    @Override
                    public void onReload() {
                        if (NetUtils.instance().isNetworkConnected((Context)WebViewActivity.this)) {
                            WebViewActivity.this.noWifiPage.dismiss(WebViewActivity.this);
                            if (!TextUtils.isEmpty((CharSequence)WebViewActivity.this.url)) {
                                WebViewActivity.this.mWebView.loadUrl(WebViewActivity.this.url);
                            }
                        }
                    }
                });
            }
            this.noWifiPage.show(this);
            if (this.noNetDialog == null) {
                this.noNetDialog = new PrivacyNoNetDialog(this, new PrivacyNoNetDialog.PrivacyNoNetClick(){

                    @Override
                    public void onPositiveClick() {
                    }
                });
            }
            if (!this.noNetDialog.isShow()) {
                if (this.getIntent().getBooleanExtra("isFAQ", false)) {
                    AthenaImpl.getInstance((Context)this).hcNetworkInvalidShow();
                } else {
                    AthenaImpl.getInstance((Context)this).pcNetworkInvalidShow();
                }
                this.noNetDialog.show(this.url);
            }
        } else {
            if (this.noWifiPage != null) {
                this.noWifiPage.dismiss(this);
            }
            if (this.noNetDialog != null) {
                this.noNetDialog.dismiss();
            }
        }
    }

    private void initActionBar() {
        int titleId = this.getIntent().getIntExtra("title", -1);
        if (titleId != -1) {
            this.getActionBar().setTitle((CharSequence)this.getString(titleId));
        }
        this.getActionBar().setDisplayHomeAsUpEnabled(true);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        this.mWebView = (WebView)this.findViewById(R.id.webView);
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setDisplayZoomControls(false);
        webSettings.setCacheMode(1);
        webSettings.setAllowFileAccess(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setMixedContentMode(0);
        webSettings.setDomStorageEnabled(true);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    if (url.contains("policy.html")) {
                        WebViewActivity.this.getActionBar().setTitle((CharSequence)WebViewActivity.this.getString(R.string.xn_privacy_policy));
                    } else if (url.contains("terms.html")) {
                        WebViewActivity.this.getActionBar().setTitle((CharSequence)WebViewActivity.this.getString(R.string.xn_user_agreement));
                    }
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                view.loadUrl(request.getUrl().toString());
                return true;
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                LogUtils.d("onReceivedSslError");
                handler.cancel();
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress == 100) {
                    WebViewActivity.this.mProgressBar.setVisibility(8);
                } else {
                    WebViewActivity.this.mProgressBar.setVisibility(0);
                    WebViewActivity.this.mProgressBar.setProgress(newProgress);
                }
            }

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                switch (consoleMessage.messageLevel()) {
                    case ERROR: {
                        LogUtils.d("webview==" + consoleMessage.message() + " level=" + consoleMessage.messageLevel());
                    }
                }
                return super.onConsoleMessage(consoleMessage);
            }
        });
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            this.mWebView.loadUrl(this.url);
        }
    }

    @Override
    protected void onDestroy() {
        if (this.mWebView != null) {
            ViewParent parent = this.mWebView.getParent();
            if (parent != null) {
                ((ViewGroup)parent).removeView((View)this.mWebView);
            }
            this.mWebView.stopLoading();
            this.mWebView.removeAllViews();
            this.mWebView.destroy();
        }
        super.onDestroy();
    }
}

