/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.login.presenter;

import android.content.Context;
import com.transsion.xuanniao.account.comm.mvpbase.BasePresenter;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.login.presenter.ICountryView;
import com.transsion.xuanniao.account.login.view.CountrySelectActivity;
import com.transsion.xuanniao.account.model.ICountryModel;
import com.transsion.xuanniao.account.model.data.CountryData;
import com.transsion.xuanniao.account.model.impl.CountryModel;
import java.util.ArrayList;

public class CountryPresenter
extends BasePresenter<ICountryView> {
    private CountryData countryData;
    private ICountryModel countryModel = new CountryModel();

    public void getCountriesFromCache() {
        this.countryModel.getCountriesFromCash((Context)this.activity(), new NetCallBack<CountryData>((Context)this.activity(), CountryData.class){

            @Override
            public void onSuccess(int code, CountryData result, String tag) {
                if (!CountryPresenter.this.isViewAttached()) {
                    return;
                }
                CountryPresenter.this.countryData = result;
                if (CountryPresenter.this.countryData == null) {
                    CountryPresenter.this.getCountriesFromNet();
                } else {
                    ((ICountryView)CountryPresenter.this.getIView()).fillDataToPage(((CountryPresenter)CountryPresenter.this).countryData.countries);
                    long now = System.currentTimeMillis();
                    if (Math.abs(now - ((CountryPresenter)CountryPresenter.this).countryData.baseTime) > ((CountryPresenter)CountryPresenter.this).countryData.validity) {
                        CountryPresenter.this.getCountriesFromNet();
                    }
                }
            }

            @Override
            public void onRetry() {
            }
        });
    }

    public void getCountriesFromNet() {
        this.countryModel.getCountriesFromNet((Context)this.activity(), new NetCallBack<CountryData>((Context)this.activity(), CountryData.class){

            @Override
            public void onSuccess(int code, CountryData result, String tag) {
                if (!CountryPresenter.this.isViewAttached()) {
                    return;
                }
                if (result != null && result.countries != null && result.countries.size() > 0) {
                    CountryPresenter.this.countryData = result;
                    ((CountryPresenter)CountryPresenter.this).countryData.baseTime = System.currentTimeMillis();
                    CountryPresenter.this.countryModel.saveCountryToCash((Context)CountryPresenter.this.activity(), CountryPresenter.this.countryData);
                    ((ICountryView)CountryPresenter.this.getIView()).fillDataToPage(((CountryPresenter)CountryPresenter.this).countryData.countries);
                }
            }

            @Override
            public void onRetry() {
            }
        });
    }

    public ArrayList<CountryData.Country> getCountries() {
        if (this.countryData == null) {
            return null;
        }
        return this.countryData.countries;
    }

    private CountrySelectActivity activity() {
        return (CountrySelectActivity)((ICountryView)this.getIView()).getContext();
    }
}

