/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.login.presenter;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseData;
import com.transsion.xuanniao.account.comm.mvpbase.BasePresenter;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.AthenaUtils;
import com.transsion.xuanniao.account.comm.utils.LanguageUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.comm.widget.CountHelper;
import com.transsion.xuanniao.account.login.presenter.ILoginView;
import com.transsion.xuanniao.account.login.view.LoginActivity;
import com.transsion.xuanniao.account.model.ICloudConfigMode;
import com.transsion.xuanniao.account.model.ILoginMode;
import com.transsion.xuanniao.account.model.IVerificationModel;
import com.transsion.xuanniao.account.model.data.AcquireCodeReq;
import com.transsion.xuanniao.account.model.data.AcquireCodeRes;
import com.transsion.xuanniao.account.model.data.ApplyKeyReq;
import com.transsion.xuanniao.account.model.data.BehaviorReq;
import com.transsion.xuanniao.account.model.data.BehaviorRes;
import com.transsion.xuanniao.account.model.data.BehaviorVerifyRes;
import com.transsion.xuanniao.account.model.data.CaptchaRes;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;
import com.transsion.xuanniao.account.model.data.CountryData;
import com.transsion.xuanniao.account.model.data.LoginByCodeReq;
import com.transsion.xuanniao.account.model.data.LoginRes;
import com.transsion.xuanniao.account.model.data.PolicyRes;
import com.transsion.xuanniao.account.model.impl.AboutMode;
import com.transsion.xuanniao.account.model.impl.ApplyKeyMode;
import com.transsion.xuanniao.account.model.impl.CloudConfigMode;
import com.transsion.xuanniao.account.model.impl.CountryModel;
import com.transsion.xuanniao.account.model.impl.LoginMode;
import com.transsion.xuanniao.account.model.impl.VerificationModel;
import tech.palm.lib.athena.AthenaImpl;

public class LoginPresenter
extends BasePresenter<ILoginView> {
    public final String TAG_USAGE = "usage";
    public final String TAG_POLICY = "Policy";
    public final String TAG_GET_CODE = "getCode";
    private final String TAG_LOGIN = "login";
    public final String TYPE_IMAGE = "IMAGE";
    public final String TYPE_BEHAVIOR = "BEHAVIOR";
    private boolean isLoginByCode = true;
    private String countryCode;
    private String countryName;
    private IVerificationModel verificationModel = new VerificationModel("LOGIN");
    private ILoginMode loginMode = new LoginMode();
    private String imageTicket;
    private String codeCaptchaCode;
    private String pwdCaptchaCode;
    private String verificationType = "BEHAVIOR";
    private boolean isFinish;
    private boolean codeNeedCaptcha;
    private int acquireCaptchaCount = 0;
    private CountHelper pwdCountHelper;
    private CountHelper captchaHelper;
    private ICloudConfigMode cloudConfigMode;
    private boolean isLoginTimeout;
    private int smsCnt = 0;
    private int picCnt = 0;
    private int emsCnt = 0;
    private int retryCnt = 0;
    private long loginStart;
    private CountryData countryData;

    public void getCountriesFromCache() {
        CountryModel countryModel = new CountryModel();
        countryModel.getCountriesFromCash((Context)this.activity(), new NetCallBack<CountryData>((Context)this.activity(), CountryData.class){

            @Override
            public void onSuccess(int code, CountryData result, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.countryData = result;
                if (LoginPresenter.this.countryData != null) {
                    ((ILoginView)LoginPresenter.this.getIView()).showPhoneCode();
                }
            }

            @Override
            public void onRetry() {
            }
        });
    }

    public void getCloudConfig() {
        if (!this.isViewAttached()) {
            return;
        }
        if (!NetUtils.instance().isNetworkConnected((Context)this.activity())) {
            return;
        }
        if (this.cloudConfigMode == null) {
            this.cloudConfigMode = new CloudConfigMode();
        }
        this.cloudConfigMode.getCloudConfig((Context)this.activity(), new NetCallBack<CloudConfigRes>((Context)this.activity(), CloudConfigRes.class){

            @Override
            public void onSuccess(int code, CloudConfigRes result, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                if (result != null && result.cloudClientConfigs != null) {
                    result.timeStamp = System.currentTimeMillis();
                    long diff = result.sysTime - System.currentTimeMillis();
                    if (Math.abs(diff) <= result.validPeriod) {
                        diff = 0L;
                    }
                    String cloudConfig = new Gson().toJson((Object)result);
                    ClientPrefs prefs = ClientPrefs.get((Context)LoginPresenter.this.activity());
                    for (CloudConfigRes.ConfigItem configItem : result.cloudClientConfigs) {
                        if (configItem == null || configItem.type != 15 || configItem.configMap == null) continue;
                        String privacyVersion = String.valueOf(configItem.configMap.get("privacyVersion"));
                        String userAgreementVersion = String.valueOf(configItem.configMap.get("userAgreementVersion"));
                        prefs.setPrivacyVersion(privacyVersion);
                        prefs.setUserAgreementVersion(userAgreementVersion);
                    }
                    prefs.setCloudConfig(cloudConfig);
                    prefs.setTimeDiff(diff);
                    prefs.save();
                    AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).remoteConfigReceived(cloudConfig);
                }
            }

            @Override
            public void onRetry() {
            }
        });
    }

    public void applyKey(String tag) {
        if (!this.isViewAttached()) {
            return;
        }
        ApplyKeyMode applyKeyMode = new ApplyKeyMode();
        ApplyKeyReq applyKeyReq = new ApplyKeyReq();
        applyKeyReq.publicKey1061 = TeeManager.instance().exportSignatureKey((Context)this.activity());
        applyKeyReq.keyId = TeeManager.instance().genKeyId((Context)this.activity());
        applyKeyMode.applyKey((Context)this.activity(), applyKeyReq, new NetCallBack<BaseData>((Context)this.activity(), tag, BaseData.class){

            @Override
            public void onSuccess(int code, BaseData result, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                TeeManager.instance().saveKeyUploaded(true);
                if ("login".equals(tag)) {
                    LoginPresenter.this.login();
                }
            }

            @Override
            public void onRetry() {
            }
        });
    }

    public void getBehaviorData(final String type, final boolean showImage) {
        BehaviorReq behaviorReq = new BehaviorReq();
        behaviorReq.verificationType = type;
        if (showImage) {
            this.activity().showWaitDialog(this.activity().getString(R.string.xn_loading));
        }
        this.verificationModel.getBehaviorData((Context)this.activity(), behaviorReq, new NetCallBack<BehaviorRes>((Context)this.activity(), BehaviorRes.class){

            @Override
            public void onSuccess(int code, BehaviorRes result, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                if (result != null) {
                    if (showImage && result.verifyCount >= result.verifyMaxCount) {
                        LoginPresenter.this.acquireCaptcha(null, true);
                    } else {
                        LoginPresenter.this.activity().hideWaitDialog();
                        ((ILoginView)LoginPresenter.this.getIView()).getBehaviorResult(result, showImage);
                        Bundle param = new Bundle();
                        param.putString("type", type);
                        param.putInt("result", 0);
                        AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).trackAccountEvent("login_behavior_verify_req", param);
                    }
                }
            }

            @Override
            public void onRetry() {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.getBehaviorData(type, showImage);
            }

            @Override
            public void onFailed(BaseData data, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.activity().hideWaitDialog();
                if (data.code != 400407) {
                    super.onFailed(data, tag);
                }
                Bundle param = new Bundle();
                param.putString("type", type);
                param.putInt("result", 1);
                param.putString("reason", String.valueOf(data.code));
                AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).trackAccountEvent("login_behavior_verify_req", param);
            }
        });
    }

    public void verifyBehavior(final String type, final String data, final String ticket, final String resId) {
        BehaviorReq behaviorReq = new BehaviorReq();
        behaviorReq.data = data;
        behaviorReq.ticket = ticket;
        this.verificationModel.verifyBehavior((Context)this.activity(), behaviorReq, new NetCallBack<BehaviorVerifyRes>((Context)this.activity(), BehaviorVerifyRes.class){

            @Override
            public void onSuccess(int code, BehaviorVerifyRes result, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                if (result != null) {
                    if (result.result) {
                        LoginPresenter.this.imageTicket = result.captchaTicket;
                        LoginPresenter.this.verificationType = "BEHAVIOR";
                    }
                    ((ILoginView)LoginPresenter.this.getIView()).verifyBehaviorResult(result, 0);
                    Bundle param = new Bundle();
                    param.putString("type", type);
                    param.putInt("result", result.result ? 1 : 0);
                    param.putString("reason", result.result ? "" : resId);
                    AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).trackAccountEvent("login_behavior_verify_result", param);
                }
            }

            @Override
            public void onRetry() {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.verifyBehavior(type, data, ticket, resId);
            }

            @Override
            public void onFailed(BaseData data2, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                if (data2.code == 400102) {
                    LoginPresenter.this.acquireCaptcha(null, true);
                    ((ILoginView)LoginPresenter.this.getIView()).verifyBehaviorResult(null, data2.code);
                }
                Bundle param = new Bundle();
                param.putString("type", type);
                param.putInt("result", 0);
                param.putString("reason", String.valueOf(data2.code));
                AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).trackAccountEvent("login_behavior_verify_result", param);
            }
        });
    }

    public void acquireCaptcha(final String tag, final boolean forceShow) {
        if (!this.isViewAttached()) {
            return;
        }
        this.verificationModel.acquireCaptcha((Context)this.activity(), forceShow, new NetCallBack<CaptchaRes>((Context)this.activity(), tag, CaptchaRes.class){

            @Override
            public void onSuccess(int code, CaptchaRes result, String tag2) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.imageTicket = result.getCaptchaTicket();
                LoginPresenter.this.verificationType = "IMAGE";
                if (LoginPresenter.this.isLoginByCode) {
                    LoginPresenter.this.codeNeedCaptcha = true;
                }
                if ("getCode".equals(tag2) && LoginPresenter.this.isLoginByCode) {
                    LoginPresenter.this.acquireCode(false);
                } else {
                    LoginPresenter.this.activity().hideWaitDialog();
                }
                if (!LoginPresenter.this.codeNeedCaptcha) {
                    LoginPresenter.this.picCnt = 0;
                }
                ((ILoginView)LoginPresenter.this.getIView()).showCaptcha(result.getCaptchaCode(), result.getCaptchaBase64());
                LoginPresenter.this.acquireCaptchaCount = 0;
            }

            @Override
            public void onRetry() {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.acquireCaptcha(tag, forceShow);
            }

            @Override
            public void onFailed(BaseData data, String tag2) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.activity().hideWaitDialog();
                if (!LoginPresenter.this.codeNeedCaptcha) {
                    LoginPresenter.this.picCnt = 0;
                }
                if (data.code == 400407) {
                    if (LoginPresenter.this.isLoginByCode) {
                        LoginPresenter.this.codeNeedCaptcha = true;
                    }
                    if (data.errorExtend != null) {
                        ClientPrefs prefs = ClientPrefs.get((Context)LoginPresenter.this.activity());
                        prefs.setCaptchaLoginLimit(data.errorExtend.getEndTime());
                        prefs.save();
                        LoginPresenter.this.showCaptchaLimit(data.errorExtend.getEndTime());
                    }
                } else {
                    super.onFailed(data, tag2);
                }
                ((ILoginView)LoginPresenter.this.getIView()).showCaptchaReduction();
            }
        });
    }

    public void acquireCode(boolean showWait) {
        if (!this.isViewAttached()) {
            return;
        }
        final boolean isPhone = ((ILoginView)this.getIView()).getType() == 3;
        ++this.smsCnt;
        AthenaImpl.getInstance((Context)this.activity()).getSmsCl(isPhone ? "Phone" : "Mail", this.smsCnt);
        if (!NetUtils.instance().isNetworkConnected((Context)this.activity())) {
            NetUtils.instance().showSetNet((Context)this.activity());
            return;
        }
        if (showWait) {
            this.activity().showWaitDialog(this.activity().getString(R.string.xn_loading));
        }
        AcquireCodeReq acquireCodeReq = new AcquireCodeReq();
        if (((ILoginView)this.getIView()).isImageCaptchaVisible()) {
            acquireCodeReq.setCaptchaCode(((ILoginView)this.getIView()).getImageCaptcha());
        } else {
            acquireCodeReq.setCaptchaCode(this.codeCaptchaCode);
        }
        acquireCodeReq.setCaptchaTicket(this.imageTicket);
        if (isPhone) {
            acquireCodeReq.setPhone(this.getCountryCode() + "-" + ((ILoginView)this.getIView()).getAccount());
        } else {
            acquireCodeReq.setEmail(((ILoginView)this.getIView()).getAccount());
            ++this.emsCnt;
        }
        acquireCodeReq.verificationType = this.verificationType;
        this.verificationModel.acquireCode((Context)this.activity(), acquireCodeReq, new NetCallBack<AcquireCodeRes>((Context)this.activity(), AcquireCodeRes.class){

            @Override
            public void onSuccess(int code, AcquireCodeRes result, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.activity().hideWaitDialog();
                AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).smsSentShow(isPhone ? "Phone" : "Mail");
                AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).getSmsResult(1, "", isPhone ? "Phone" : "Mail", LoginPresenter.this.smsCnt);
                ((ILoginView)LoginPresenter.this.getIView()).acquireCodeSuccess();
            }

            @Override
            public void onRetry() {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.acquireCode(false);
            }

            @Override
            public void onFailed(BaseData data, String tag) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).getSmsResult(0, String.valueOf(data.code), isPhone ? "Phone" : "Mail", LoginPresenter.this.smsCnt);
                LoginPresenter.this.activity().hideWaitDialog();
                ((ILoginView)LoginPresenter.this.getIView()).updateVerifyView();
                if (data.code == 400408) {
                    AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).smsExceedShow(isPhone ? "Phone" : "Mail");
                    ((ILoginView)LoginPresenter.this.getIView()).showAcquireCodeDayLimit();
                } else if (data.code == 400409) {
                    AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).smsExceedShow(isPhone ? "Phone" : "Mail");
                    ((ILoginView)LoginPresenter.this.getIView()).showAcquireCodeMonthLimit();
                } else if (data.code == 400100) {
                    AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).picVerifyWrongShow();
                    ((ILoginView)LoginPresenter.this.getIView()).byCodeShowCaptchaError();
                } else {
                    super.onFailed(data, tag);
                }
            }
        });
    }

    public void showFivePwdLimit(long time) {
        long count = time - System.currentTimeMillis();
        if (count > 0L) {
            this.clearCount();
            this.pwdCountHelper = new CountHelper(new CountHelper.CountListener(){

                @Override
                public void countFinish() {
                    if (!LoginPresenter.this.isViewAttached()) {
                        return;
                    }
                    ((ILoginView)LoginPresenter.this.getIView()).showFiveLimitError(false, 0L);
                }

                @Override
                public void onTick(long millisUntilFinished) {
                    if (!LoginPresenter.this.isViewAttached()) {
                        return;
                    }
                    ((ILoginView)LoginPresenter.this.getIView()).showFiveLimitError(true, millisUntilFinished);
                }
            });
            this.pwdCountHelper.init(count);
            this.pwdCountHelper.startCount();
        }
    }

    public void showCaptchaLimit(long time) {
        long count = time - System.currentTimeMillis();
        if (count > 0L) {
            this.clearCount();
            this.captchaHelper = new CountHelper(new CountHelper.CountListener(){

                @Override
                public void countFinish() {
                    if (!LoginPresenter.this.isViewAttached()) {
                        return;
                    }
                    ((ILoginView)LoginPresenter.this.getIView()).showCaptchaLimitError(false, 0L);
                }

                @Override
                public void onTick(long millisUntilFinished) {
                    if (!LoginPresenter.this.isViewAttached()) {
                        return;
                    }
                    ((ILoginView)LoginPresenter.this.getIView()).showCaptchaLimitError(true, millisUntilFinished);
                }
            });
            this.captchaHelper.init(count);
            this.captchaHelper.startCount();
        }
    }

    public void clearCount() {
        if (this.pwdCountHelper != null) {
            this.pwdCountHelper.clearCount();
        }
        if (this.captchaHelper != null) {
            this.captchaHelper.clearCount();
        }
    }

    public boolean isShowPwdLimit() {
        if (this.pwdCountHelper != null) {
            return this.pwdCountHelper.isCounting();
        }
        return false;
    }

    public boolean isShowCaptchaLimit() {
        if (this.captchaHelper != null) {
            return this.captchaHelper.isCounting();
        }
        return false;
    }

    public void login() {
        if (!this.isViewAttached()) {
            return;
        }
        ++this.retryCnt;
        if (TeeManager.instance().isTeeEnable() && !TeeManager.instance().getIsKeyUploaded() && NetUtils.instance().isNetworkConnected((Context)this.activity())) {
            this.applyKey("TAG_LOGIN");
            return;
        }
        if (this.isLoginByCode) {
            this.loginByCode();
        }
    }

    private String loginBy() {
        return AthenaUtils.loginBy(this.isLoginByCode, ((ILoginView)this.getIView()).getType() == 3, ((ILoginView)this.getIView()).getType() == 2);
    }

    public void smsFillEnd() {
        AthenaImpl.getInstance((Context)this.activity()).smsFillEnd(((ILoginView)this.getIView()).getType() == 3 ? "Phone" : "Mail", this.smsCnt);
    }

    private void loginByCode() {
        String account;
        if (!this.isViewAttached()) {
            return;
        }
        if (!NetUtils.instance().isNetworkConnected((Context)this.activity())) {
            NetUtils.instance().showSetNet((Context)this.activity());
            AthenaImpl.getInstance((Context)this.activity()).networkInvalidShow();
            return;
        }
        AthenaImpl.getInstance((Context)this.activity()).loginStart(this.loginBy(), this.picCnt, this.smsCnt - this.emsCnt, this.emsCnt);
        this.activity().showWaitDialog(this.activity().getString(R.string.xn_loading_verify_account));
        LoginByCodeReq loginByCodeReq = new LoginByCodeReq();
        loginByCodeReq.setExtraInfo(1);
        if (((ILoginView)this.getIView()).getType() == 3) {
            account = this.getCountryCode() + "-" + ((ILoginView)this.getIView()).getAccount();
            loginByCodeReq.setPhone(account);
        } else {
            account = ((ILoginView)this.getIView()).getAccount();
            loginByCodeReq.setEmail(account);
        }
        loginByCodeReq.setVerificationCode(((ILoginView)this.getIView()).getVerificationCode());
        try {
            LogUtils.d("loginByVerificationCode");
            this.loginMode.loginByVerificationCode((Context)this.activity(), loginByCodeReq, new NetCallBack<LoginRes>((Context)this.activity(), LoginRes.class){

                @Override
                public void onSuccess(int code, LoginRes result, String tag) {
                    if (!LoginPresenter.this.isViewAttached()) {
                        return;
                    }
                    LoginPresenter.this.activity().hideWaitDialog();
                    AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).loginEnd(LoginPresenter.this.loginBy(), 1, "", System.currentTimeMillis() - LoginPresenter.this.loginStart);
                    if (result != null && result.account != null) {
                        LoginPresenter.this.saveToken(result, 0, account, 0);
                        ((ILoginView)LoginPresenter.this.getIView()).saveAccount(result.account);
                        ((ILoginView)LoginPresenter.this.getIView()).loginSuccess(result.token.eventType, result);
                    } else {
                        LoginPresenter.this.activity().warning(LoginPresenter.this.activity().getString(R.string.xn_net_unavailable));
                    }
                }

                @Override
                public void onRetry() {
                    if (!LoginPresenter.this.isViewAttached()) {
                        return;
                    }
                    LoginPresenter.this.loginByCode();
                }

                @Override
                public void onFailed(BaseData data, String tag) {
                    if (!LoginPresenter.this.isViewAttached()) {
                        return;
                    }
                    AthenaImpl.getInstance((Context)LoginPresenter.this.activity()).loginEnd(LoginPresenter.this.loginBy(), 0, String.valueOf(data.code), System.currentTimeMillis() - LoginPresenter.this.loginStart);
                    LoginPresenter.this.activity().hideWaitDialog();
                    ((ILoginView)LoginPresenter.this.getIView()).updateVerifyView();
                    if (data.code == 400100) {
                        ((ILoginView)LoginPresenter.this.getIView()).showCodeError();
                    } else if (data.code == 400410) {
                        ((ILoginView)LoginPresenter.this.getIView()).showCodeError();
                        ((ILoginView)LoginPresenter.this.getIView()).showCodeHelpTips();
                    } else {
                        super.onFailed(data, tag);
                    }
                }
            });
        }
        catch (Exception e) {
            LogUtils.d(Log.getStackTraceString((Throwable)e));
            this.activity().hideWaitDialog();
        }
    }

    public void getPolice(final String tag) {
        if (!this.isViewAttached()) {
            return;
        }
        this.activity().showWaitDialog(this.activity().getString(R.string.xn_loading));
        AboutMode aboutMode = new AboutMode();
        aboutMode.getPolicy((Context)this.activity(), LanguageUtils.getLocalLanguage((Context)this.activity()), this.getType(), new NetCallBack<PolicyRes>((Context)this.activity(), tag, PolicyRes.class){

            @Override
            public void onSuccess(int code, PolicyRes result, String tag2) {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.activity().hideWaitDialog();
                ((ILoginView)LoginPresenter.this.getIView()).getPoliceSuccess(result, tag2);
            }

            @Override
            public void onRetry() {
                if (!LoginPresenter.this.isViewAttached()) {
                    return;
                }
                LoginPresenter.this.getPolice(tag);
            }
        });
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public void setFinish(boolean finish) {
        this.isFinish = finish;
    }

    private void saveToken(LoginRes login, int loginType, String account, int codeType) {
        ClientPrefs prefs = ClientPrefs.get((Context)this.activity());
        prefs.setLastLoginReq(loginType, account, codeType);
        prefs.save();
    }

    private LoginActivity activity() {
        return (LoginActivity)((ILoginView)this.getIView()).getContext();
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public CountryData getCountryData() {
        return this.countryData;
    }

    public void setCountryData(CountryData countryData) {
        this.countryData = countryData;
    }

    public String getCountryCode() {
        if (TextUtils.isEmpty((CharSequence)this.countryCode) && this.countryData != null && this.countryData.countries != null) {
            this.countryCode = CountryData.getCountryCode(((ILoginView)this.getIView()).getContext(), this.countryData.countries);
            this.countryName = ClientPrefs.get((Context)this.activity()).getCountryName();
        }
        return this.countryCode;
    }

    public String getCountryCodeWithPlus() {
        if (TextUtils.isEmpty((CharSequence)this.countryCode) && this.countryData != null && this.countryData.countries != null) {
            this.countryCode = CountryData.getCountryCode(((ILoginView)this.getIView()).getContext(), this.countryData.countries);
        }
        if (TextUtils.isEmpty((CharSequence)this.countryCode)) {
            return this.countryCode;
        }
        return "+" + this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean isLoginByCode() {
        return this.isLoginByCode;
    }

    public void setLoginByCode(boolean loginByCode) {
        this.isLoginByCode = loginByCode;
    }

    public void switchLoginMode() {
        this.isLoginByCode = !this.isLoginByCode;
    }

    public String getImageTicket() {
        return this.imageTicket;
    }

    public boolean isCodeNeedCaptcha() {
        return this.codeNeedCaptcha;
    }

    public void setCodeNeedCaptcha(boolean codeNeedCaptcha) {
        this.codeNeedCaptcha = codeNeedCaptcha;
    }

    public void setLoginStart(long loginStart) {
        this.loginStart = loginStart;
    }

    private String getType() {
        if (TextUtils.equals((CharSequence)this.activity().getPackageName(), (CharSequence)"tech.palm.id")) {
            return "palmId";
        }
        return "sdk";
    }

    public void saveState(Bundle outState) {
        outState.putString("lp_ticket", this.imageTicket);
        outState.putString("lp_verify_type", this.verificationType);
        outState.putBoolean("lp_login_code", this.isLoginByCode);
        outState.putBoolean("lp_code_captcha", this.codeNeedCaptcha);
    }

    public void restoreState(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey("lp_ticket")) {
                this.imageTicket = inState.getString("lp_ticket");
            }
            if (inState.containsKey("lp_verify_type")) {
                this.verificationType = inState.getString("lp_verify_type");
            }
            if (inState.containsKey("lp_login_code")) {
                this.setLoginByCode(inState.getBoolean("lp_login_code"));
            }
            if (inState.containsKey("lp_code_captcha")) {
                this.setCodeNeedCaptcha(inState.getBoolean("lp_code_captcha"));
            }
        }
    }
}

