/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.login.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.BitmapUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import com.transsion.xuanniao.account.comm.widget.BehaviorImageView;
import com.transsion.xuanniao.account.comm.widget.BehaviorSlideView;
import com.transsion.xuanniao.account.model.data.BehaviorRes;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class BehaviorVerifyDialog {
    public static final int TYPE_SINGLE = 0;
    public static final int TYPE_MULTIPLE = 1;
    public static final int TYPE_SLIDER = 2;
    private TextView tvTips;
    private TextView tvResult;
    private ImageView ivRefresh;
    private View viewLoading;
    private BehaviorRes behaviorRes;
    private BehaviorImageView verifyImage;
    private BehaviorSlideView slideView;
    private Dialog promptDialog;
    private BehaviorListener behaviorListener;

    public void show(Activity context) {
        if (this.promptDialog == null) {
            this.promptDialog = new AlertDialog.Builder((Context)context, R.style.dialog_soft_input_center).setView(R.layout.xn_behavior_verify_dialog).create();
            this.promptDialog.setCanceledOnTouchOutside(false);
            this.promptDialog.show();
            this.promptDialog.findViewById(R.id.ivClose).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BehaviorVerifyDialog.this.dismiss();
                }
            });
            this.ivRefresh = (ImageView)this.promptDialog.findViewById(R.id.ivRefresh);
            this.ivRefresh.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ObjectAnimator.ofFloat((Object)BehaviorVerifyDialog.this.ivRefresh, (String)"rotation", (float[])new float[]{0.0f, -360.0f}).setDuration(500L).start();
                    BehaviorVerifyDialog.this.viewLoading.setVisibility(0);
                    if (BehaviorVerifyDialog.this.behaviorListener != null) {
                        BehaviorVerifyDialog.this.behaviorListener.refreshClick();
                    }
                }
            });
            this.viewLoading = this.promptDialog.findViewById(R.id.viewLoading);
            this.tvTips = (TextView)this.promptDialog.findViewById(R.id.tvTips);
            this.tvResult = (TextView)this.promptDialog.findViewById(R.id.tvResult);
            this.verifyImage = (BehaviorImageView)this.promptDialog.findViewById(R.id.verifyImage);
            this.verifyImage.setClickListener(new BehaviorImageView.ImageClickListener(){

                @Override
                public void onTouch(float xPos, float yPos) {
                    if (BehaviorVerifyDialog.this.behaviorRes != null && BehaviorVerifyDialog.this.behaviorListener != null) {
                        try {
                            String data = new JSONArray().put((Object)new JSONObject().put("xPos", (double)(xPos * 100.0f)).put("yPos", (double)(yPos * 100.0f))).toString();
                            BehaviorVerifyDialog.this.behaviorListener.startVerify(RSAEncryptUtil.encrypt(data, ((BehaviorVerifyDialog)BehaviorVerifyDialog.this).behaviorRes.publicKey), ((BehaviorVerifyDialog)BehaviorVerifyDialog.this).behaviorRes.ticket, UUID.nameUUIDFromBytes(((BehaviorVerifyDialog)BehaviorVerifyDialog.this).behaviorRes.bg.getBytes()).toString());
                        }
                        catch (Exception e) {
                            LogUtils.d(Log.getStackTraceString((Throwable)e));
                        }
                    }
                }
            });
            this.slideView = (BehaviorSlideView)this.promptDialog.findViewById(R.id.slideView);
            this.slideView.setSlideListener(new BehaviorSlideView.SlideListener(){

                @Override
                public void onViewSlide(float distance) {
                    BehaviorVerifyDialog.this.verifyImage.setXPos(distance);
                }

                @Override
                public void onViewReleased(float xPos) {
                    if (BehaviorVerifyDialog.this.behaviorRes != null && BehaviorVerifyDialog.this.behaviorListener != null) {
                        BehaviorVerifyDialog.this.slideView.setDragEnable(false);
                        try {
                            String data = new JSONArray().put((Object)new JSONObject().put("xPos", (double)(xPos * 100.0f)).put("yPos", (double)((BehaviorVerifyDialog)BehaviorVerifyDialog.this).behaviorRes.ypos)).toString();
                            BehaviorVerifyDialog.this.behaviorListener.startVerify(RSAEncryptUtil.encrypt(data, ((BehaviorVerifyDialog)BehaviorVerifyDialog.this).behaviorRes.publicKey), ((BehaviorVerifyDialog)BehaviorVerifyDialog.this).behaviorRes.ticket, UUID.nameUUIDFromBytes(((BehaviorVerifyDialog)BehaviorVerifyDialog.this).behaviorRes.bg.getBytes()).toString());
                        }
                        catch (Exception e) {
                            LogUtils.d(Log.getStackTraceString((Throwable)e));
                        }
                    }
                }
            });
        } else {
            this.initView();
            if (!this.promptDialog.isShowing()) {
                this.promptDialog.show();
            }
        }
    }

    private void initView() {
        this.tvResult.setVisibility(8);
        if (this.verifyImage != null) {
            this.verifyImage.setData(-1, 0.0f, null, null);
        }
        if (this.slideView != null) {
            this.slideView.reset();
            this.slideView.setVisibility(8);
        }
    }

    public void setBehaviorListener(BehaviorListener listener) {
        this.behaviorListener = listener;
    }

    public void setData(BehaviorRes res, Bitmap bgBitmap) {
        if (res == null) {
            this.viewLoading.setVisibility(8);
            this.slideView.setDragEnable(true);
        } else {
            int type = this.stringToInt(res.verificationType);
            this.behaviorRes = res;
            this.viewLoading.setVisibility(8);
            this.tvTips.setText(type == 2 ? R.string.xn_behavior_drag : R.string.xn_behavior_click_o);
            this.verifyImage.setData(type, res.ypos, BitmapUtils.base64ToBitmap(res.slide), bgBitmap);
            this.slideView.setVisibility(type == 2 ? 0 : 8);
            this.slideView.setDragEnable(true);
        }
    }

    public void resetWithError() {
        this.viewLoading.setVisibility(0);
        this.tvResult.setText(R.string.xn_behavior_fail);
        this.tvResult.animate().setDuration(1000L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                BehaviorVerifyDialog.this.tvResult.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                BehaviorVerifyDialog.this.tvResult.setVisibility(4);
            }
        }).start();
        if (2 == this.stringToInt(this.behaviorRes.verificationType)) {
            this.slideView.resetWithError();
        }
    }

    public boolean isShowing() {
        if (this.promptDialog != null) {
            return this.promptDialog.isShowing();
        }
        return false;
    }

    public void dismiss() {
        if (this.promptDialog != null && this.promptDialog.isShowing()) {
            this.promptDialog.dismiss();
        }
    }

    private int stringToInt(String vType) {
        if ("SLIDE".equals(vType)) {
            return 2;
        }
        if ("SINGLE_CLICK".equals(vType)) {
            return 0;
        }
        return 0;
    }

    public static interface BehaviorListener {
        public void refreshClick();

        public void startVerify(String var1, String var2, String var3);
    }
}

