/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.model.data;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.net.Utils;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.model.data.AccountRes;
import java.io.Serializable;
import java.lang.reflect.Method;

public class ConfigReq
implements Serializable {
    public String versionId;
    public String osVersion;
    public String gaid;
    public String mcc;
    public String language;
    public String brand;
    public String androidVersion;
    public String buildNumber;
    public String businessGroup;
    public String appVersion;
    public String network;
    public String accountId;
    public String openId;
    public String cpuId;
    public String appId;

    public static ConfigReq generateReq(Context context) {
        ConfigReq req = new ConfigReq();
        req.osVersion = ConfigReq.getOsVersion();
        req.gaid = DeviceInfo.getGAId();
        req.mcc = context == null ? null : ConfigReq.getOperatorMccOrLegacy(context);
        req.language = context == null ? null : context.getResources().getConfiguration().locale.getLanguage().toLowerCase();
        req.brand = Build.BRAND;
        req.androidVersion = Build.VERSION.RELEASE;
        req.buildNumber = Build.DISPLAY;
        req.businessGroup = "";
        if (context != null) {
            req.appVersion = Utils.getVersionName(context, context.getPackageName());
        }
        req.network = NetUtils.instance().getNetworkType(context);
        AccountRes account = TeeManager.instance().getAccountInfo();
        if (account != null) {
            req.accountId = account.xuanniaoId;
        }
        req.cpuId = ConfigReq.getCpuId(context);
        req.appId = XNApiManager.instance().getClientId();
        return req;
    }

    public static String getOsVersion() {
        String osVersion = ConfigReq.SystemPropertiesGet("ro.tranos.version");
        if (TextUtils.isEmpty((CharSequence)osVersion)) {
            osVersion = ConfigReq.SystemPropertiesGet("ro.os_product.version");
        }
        return osVersion;
    }

    public static String SystemPropertiesGet(String key) {
        try {
            Class<?> cl = Class.forName("android.os.SystemProperties");
            Method method = cl.getMethod("get", String.class);
            String value = (String)method.invoke(null, key);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOperatorMccOrLegacy(Context context) {
        TelephonyManager mTelephonyManager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
        String operator = mTelephonyManager.getNetworkOperator();
        if (TextUtils.isEmpty((CharSequence)operator) && operator.length() > 2) {
            return operator.substring(0, 3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"all"})
    public static String getCpuId(Context context) {
        String cpuId = null;
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = null;
        Uri uri = Uri.parse((String)"content://com.hoffnung.DeviceInfoProvider");
        try {
            cursor = cr.query(uri, null, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                cpuId = cursor.getString(cursor.getColumnIndex("cpuid"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return cpuId;
    }
}

