/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.model.data;

import android.content.Context;
import android.text.TextUtils;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.utils.OSUtils;
import com.transsion.xuanniao.account.comm.utils.SystemPropertiesProxy;
import com.transsion.xuanniao.account.model.data.CacheCountries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class CountryData
implements Serializable {
    public ArrayList<Country> countries;
    public long validity;
    public long baseTime;

    public static String getCountryCode(Context context, ArrayList<Country> countryData) {
        ClientPrefs prefs = ClientPrefs.get(context);
        String code = prefs.getCountryCode();
        if (code.isEmpty() && countryData != null) {
            String mcc = OSUtils.getMcc(context);
            if (!TextUtils.isEmpty((CharSequence)mcc)) {
                for (Country country : countryData) {
                    if (!country.mcc.equals(mcc)) continue;
                    code = country.code;
                }
            } else {
                String country = SystemPropertiesProxy.get(context, "persist.sys.oobe_country");
                if (!TextUtils.isEmpty((CharSequence)country)) {
                    for (Country item : countryData) {
                        if (!country.equalsIgnoreCase(item.iso)) continue;
                        code = item.code;
                    }
                }
            }
        }
        if (TextUtils.isEmpty((CharSequence)code)) {
            Locale l = Locale.getDefault();
            String countryName = l.getDisplayCountry(Locale.US);
            if (countryName.contains("(")) {
                String[] stringArray = countryName.split("\\(");
                countryName = stringArray[0].trim();
            }
            if ("russia".equalsIgnoreCase(countryName)) {
                countryName = "Russian Federation";
            } else if ("United States".equalsIgnoreCase(countryName)) {
                countryName = "United States of America";
            }
            code = CountryData.getCode(countryName, countryData);
        }
        return code;
    }

    public static String getCode(String name, ArrayList<Country> countries) {
        if ("Taiwan".equals(name)) {
            name = "Taiwan/China";
        }
        if (countries != null) {
            for (int i = 0; i < countries.size(); ++i) {
                if (!TextUtils.equals((CharSequence)countries.get((int)i).country, (CharSequence)name) && !TextUtils.equals((CharSequence)countries.get((int)i).localName, (CharSequence)name)) continue;
                return countries.get((int)i).code;
            }
        }
        return "";
    }

    public static CountryData makeCountryData(Context context) {
        CountryData countryData = new CountryData();
        countryData.validity = 0L;
        countryData.baseTime = 0L;
        countryData.countries = new ArrayList();
        for (Country country : CacheCountries.countriesData) {
            Country item = new Country(country.iso, country.localName, country.country, country.code, country.mcc, 0);
            item.displayName = country.resId == R.string.HK || country.resId == R.string.TW || country.resId == R.string.MO ? context.getString(R.string.xn_china) + "/" + context.getString(country.resId) : context.getResources().getString(country.resId);
            countryData.countries.add(item);
        }
        return countryData;
    }

    public static String getCountryName(Context context, String enName, ArrayList<Country> countries) {
        for (int i = 0; i < countries.size(); ++i) {
            if (!TextUtils.equals((CharSequence)enName, (CharSequence)countries.get((int)i).country)) continue;
            int id2 = countries.get((int)i).resId;
            if (id2 == R.string.HK || id2 == R.string.TW || id2 == R.string.MO) {
                return context.getString(R.string.xn_china) + "/" + context.getString(id2);
            }
            return context.getString(id2);
        }
        return enName;
    }

    public static String getCode(Context context, String name, ArrayList<Country> countries) {
        String enName = CountryData.getEnName(context, name, countries);
        return CountryData.getCode(enName, countries);
    }

    public static String getEnName(Context context, String name, ArrayList<Country> countries) {
        if (!TextUtils.isEmpty((CharSequence)name) && countries != null) {
            for (int i = 0; i < countries.size(); ++i) {
                String matchName = null;
                int id2 = countries.get((int)i).resId;
                matchName = id2 == R.string.HK || id2 == R.string.TW || id2 == R.string.MO ? context.getString(R.string.xn_china) + "/" + context.getString(id2) : (id2 > 0 ? context.getString(id2) : countries.get((int)i).displayName);
                if (!TextUtils.equals((CharSequence)name, (CharSequence)matchName)) continue;
                return countries.get((int)i).country;
            }
        }
        return "";
    }

    public static class Country
    implements Serializable {
        public String country;
        public String code;
        public String mcc;
        public int resId;
        public boolean isSelected;
        public String localName;
        public String iso;
        public String language;
        public String displayName;

        public Country(String iso, String localName, String country, String code, String mcc, int resId, boolean isSelected) {
            this.iso = iso;
            this.country = country;
            this.code = code;
            this.mcc = mcc;
            this.resId = resId;
            this.isSelected = isSelected;
            this.localName = localName;
        }

        public Country(String iso, String localName, String country, String code, String mcc, int resId) {
            this(iso, localName, country, code, mcc, resId, false);
        }
    }
}

