/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.model.impl;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.net.NetWorkProxy;
import com.transsion.xuanniao.account.comm.utils.FileUtil;
import com.transsion.xuanniao.account.model.ICountryModel;
import com.transsion.xuanniao.account.model.data.CountryData;
import com.transsion.xuanniao.account.model.data.CountryListReq;

public class CountryModel
implements ICountryModel {
    @Override
    public <T> void getCountriesFromNet(Context context, NetCallBack<T> netCallBack) {
        NetWorkProxy proxy = new NetWorkProxy(context);
        CountryListReq req = new CountryListReq();
        req.appId = XNApiManager.instance().getClientId();
        req.language = context.getResources().getString(R.string.xn_language);
        proxy.requestPost("/app/country/list", req, netCallBack);
    }

    @Override
    public void getCountriesFromCash(Context context, NetCallBack<CountryData> netCallBack) {
        new Thread(() -> {
            CountryListReq req = new CountryListReq();
            req.appId = XNApiManager.instance().getClientId();
            req.language = context.getResources().getString(R.string.xn_language);
            String path = context.getCacheDir().getAbsolutePath() + "/" + req.language + ".txt";
            String json = FileUtil.readTxtFile(path);
            if (TextUtils.isEmpty((CharSequence)json)) {
                netCallBack.postSuccess(CountryData.makeCountryData(context));
            } else {
                try {
                    Gson gson = new Gson();
                    CountryData data = (CountryData)gson.fromJson(json, CountryData.class);
                    for (CountryData.Country country : data.countries) {
                        country.isSelected = false;
                    }
                    netCallBack.postSuccess(data);
                }
                catch (Exception e) {
                    netCallBack.onFailed(null, null);
                }
            }
        }).start();
    }

    @Override
    public void saveCountryToCash(Context context, CountryData data) {
        new Thread(() -> {
            if (data != null && data.countries != null && data.countries.size() > 0) {
                Gson gson = new Gson();
                String path = context.getCacheDir().getAbsolutePath();
                FileUtil.writeTxtToFile(gson.toJson((Object)data), path, data.countries.get((int)0).language + ".txt");
            }
        }).start();
    }
}

