/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.model.impl;

import android.content.Context;
import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.net.NetWorkProxy;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.model.ILoginMode;
import com.transsion.xuanniao.account.model.data.CommReq;
import com.transsion.xuanniao.account.model.data.LoginByCodeReq;
import com.transsion.xuanniao.account.model.data.LoginCaptchaReq;
import java.util.HashMap;

public class LoginMode
implements ILoginMode {
    @Override
    public <T> void loginByPwdWithCaptcha(Context context, LoginCaptchaReq params, NetCallBack<T> netCallBack) throws Exception {
        params.clientId = XNApiManager.instance().getClientId();
        NetWorkProxy proxy = new NetWorkProxy(context);
        CipherHelper cipherHelper = TeeManager.instance().generateCipher();
        netCallBack.setCipherHelper(cipherHelper);
        Object req = CommReq.generateReq(context, cipherHelper, params);
        proxy.requestPost("/sdk/login/login-by-password-with-captcha-crypt", req, netCallBack);
    }

    @Override
    public <T> void loginByVerificationCode(Context context, LoginByCodeReq params, NetCallBack<T> netCallBack) throws Exception {
        params.setClientId(XNApiManager.instance().getClientId());
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost("/sdk/login/login-by-verificationcode", params, netCallBack);
    }

    @Override
    public <T> void refreshToken(Context context, String refreshToken, NetCallBack<T> netCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refreshToken", refreshToken);
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost("/sdk/login/refresh-token", params, netCallBack);
    }

    @Override
    public <T> void logout(Context context, NetCallBack<T> netCallBack) {
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestGet("/sdk/login/logout", null, netCallBack);
    }
}

