package com.transsion.xuanniao.account.comm.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Base64;

import com.transsion.xuanniao.account.comm.net.GlobalHandler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;

public class BitmapUtils {

    public static Bitmap decodeFile(String path, int maxWidth, int maxHeight){
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true; //只读取图片尺寸
        Bitmap scanBitmap = BitmapFactory.decodeFile(path, options);

        //计算实际缩放比例
        int scale = 1;
        for (int i = 0; i < Integer.MAX_VALUE; i++) {
            if ((options.outWidth / scale > maxWidth &&
                    options.outWidth / scale > maxWidth * 1.4) ||
                    (options.outHeight / scale > maxHeight &&
                            options.outHeight / scale > maxHeight * 1.4)) {
                scale++;
            } else {
                break;
            }
        }

        options.inSampleSize = scale;
        options.inJustDecodeBounds = false;//读取图片内容
        options.inPreferredConfig = Bitmap.Config.RGB_565; //根据情况进行修改
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile(path, options);
        }catch (Exception e){
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap decodeFile(String path){
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile(path);
        }catch (Exception e){
            e.printStackTrace();
        }
        return bitmap;
    }

    public static void saveBitmapPng(String path, Bitmap bitmap){
        File file = new File(path);
        if (file.exists()){
            file.delete();
        }else {
            file.mkdirs();
        }

        try{
            FileOutputStream out = new FileOutputStream(file);
            if(bitmap.compress(Bitmap.CompressFormat.PNG, 100, out))
            {
                out.flush();
                out.close();
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap base64ToBitmap(String base64){
        if (TextUtils.isEmpty(base64)){
            return null;
        }
        byte[] bytes = Base64.decode(base64, Base64.DEFAULT);
        return BitmapFactory.decodeByteArray(bytes, 0, bytes.length);
    }

    public static Bitmap getPic(String url) {
        try {
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url(url).build();
            ResponseBody body = client.newCall(request).execute().body();
            InputStream in = body.byteStream();

            Bitmap bitmap = BitmapFactory.decodeStream(in);
            return bitmap;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveBitmap(String url,String path,SaveBitmap saveBitmap){
        new Thread(new Runnable() {
            @Override
            public void run() {
               Bitmap bitmap =  getPic(url);
               if (bitmap != null){
                   saveBitmapPng(path,bitmap);
               }
                GlobalHandler.getInstance().runInMain(new Runnable() {
                    @Override
                    public void run() {
                        if (saveBitmap != null) saveBitmap.onFinish(path);
                    }
                });
            }
        }).start();
    }
    public interface SaveBitmap{
        void onFinish(String path);
    }
}
