package com.transsion.xuanniao.account.model.impl;

import android.content.Context;

import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.net.NetWorkProxy;
import com.transsion.xuanniao.account.comm.net.UrlFactory;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.model.ILoginMode;
import com.transsion.xuanniao.account.model.data.CommReq;
import com.transsion.xuanniao.account.model.data.LoginByCodeReq;
import com.transsion.xuanniao.account.model.data.LoginCaptchaReq;

import java.util.HashMap;

/**
 * @Description:
 * @author： 胡南 on 2021/4/20
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class LoginMode implements ILoginMode {
//    @Override
//    public <T> void loginByPwd(Context context, LoginReq params, NetCallBack<T> netCallBack) {
//        params.clientId = XNApiManager.instance().getClientId();
//        NetWorkProxy proxy = new NetWorkProxy(context);
//        proxy.requestPost(UrlFactory.LOGIN_BY_PWD,params,netCallBack);
//    }

    @Override
    public <T> void loginByPwdWithCaptcha(Context context, LoginCaptchaReq params, NetCallBack<T> netCallBack) throws Exception {
        params.clientId = XNApiManager.instance().getClientId();
        NetWorkProxy proxy = new NetWorkProxy(context);
        CipherHelper cipherHelper = TeeManager.instance().generateCipher();
        netCallBack.setCipherHelper(cipherHelper);
        Object req = CommReq.generateReq(context, cipherHelper, params);
        proxy.requestPost(UrlFactory.LOGIN_BY_PWD_CAPTCHA_CRYPT, req, netCallBack);
    }
//    @Override
//    public <T> void loginByPwdWithCaptcha(Context context, LoginCaptchaReq params, NetCallBack<T> netCallBack) {
//        params.clientId = XNApiManager.instance().getClientId();
//        NetWorkProxy proxy = new NetWorkProxy(context);
//        proxy.requestPost(UrlFactory.LOGIN_BY_PWD_CAPTCHA,params,netCallBack);
//    }

    @Override
    public <T> void loginByVerificationCode(Context context,LoginByCodeReq params, NetCallBack<T> netCallBack) throws Exception {
        params.setClientId(XNApiManager.instance().getClientId());
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost(UrlFactory.LOGIN_BY_SMS,params,netCallBack);
    }

    @Override
    public <T> void refreshToken(Context context, String refreshToken, NetCallBack<T> netCallBack) {
        HashMap<String,Object> params = new HashMap<>();
        params.put("refreshToken", refreshToken);
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost(UrlFactory.LOGIN_REFRESH,params,netCallBack);
    }

    @Override
    public <T> void logout(Context context, NetCallBack<T> netCallBack) {
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestGet(UrlFactory.LOGOUT,null,netCallBack);
    }
}
