/**
 * CopyRight (c) 2016-2021 Transsion .Co.Ltd.
 */

package com.transsion.xuanniao.account.comm.utils;

import com.transsion.core.log.LogUtils;

/**
 * <类型转换工具 BR>
 *
 * @author ming.wang
 * @version [V8.0, 2021/6/18]
 * @since V8.0
 */
public final class CastUtils {
    /**
     * 日志标识
     */
    private static final String TAG = "CastUtils";

    /**
     * 转换方法
     *
     * @param obj 原始对象
     * @param clz 转换目标类型
     * @param <T> 字节码类型
     * @return 目标类型对象
     */
    public static <T> T cast(Object obj, Class<T> clz) {
        if (clz == null) {
            LogUtils.i(TAG, "class is null");
            return null;
        } else {
            return clz.isInstance(obj) ? (T) obj : null;
        }
    }
}
