package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import com.transsion.widgetslib.util.Utils;
import com.transsion.xuanniao.account.R;

/**
 * @Description:
 * @author： 胡南 on 2021/8/16
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class XNClickableSpan extends ClickableSpan {
    private Context context;
    private ClickListen listen;
    private long lastClick = 0;
    public XNClickableSpan(Context context,ClickListen listen){
        this.context = context;
        this.listen = listen;
    }
    @Override
    public void onClick(@NonNull View widget) {
        long diff = Math.abs(System.currentTimeMillis() - lastClick);
        lastClick = System.currentTimeMillis();
        if (diff < 1000){
            return;
        }
        if (listen != null){
            listen.onClick(widget);
        }
    }

    @Override
    public void updateDrawState(@NonNull TextPaint ds) {
        super.updateDrawState(ds);
        super.updateDrawState(ds);
        ds.setUnderlineText(false);

        try {
            ds.setColor(Utils.getOsPlatformBasicColor(context));
        } catch (Throwable e) {
            ds.setColor(ContextCompat.getColor(context, R.color.xn_link_color));  // for定制
        }
    }

    public interface ClickListen{
        void onClick(@NonNull View widget);
    }
}