package com.transsion.xuanniao.account.login.view;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.view.Gravity;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;

/**
 * @Description:
 * @author： 胡南 on 2021/5/20
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class PrivacyNoNetDialog {
    private PromptDialog promptDialog;
    private BaseActivity context;
    private PrivacyNoNetClick noNetClick;
    public PrivacyNoNetDialog(BaseActivity context, PrivacyNoNetClick noNetClick){
        this.context = context;
        this.noNetClick = noNetClick;
    }

    @SuppressLint({"StringFormatInvalid", "StringFormatMatches"})
    public void show(String url){
        if (promptDialog == null){
            promptDialog = new PromptDialog.Builder(context, R.style.dialog_soft_input)
                    .setView(R.layout.xn_privacy_no_net_dialog)
                    .setTitle(context.getString(R.string.xn_no_net))
                    .setPositiveButton(context.getString(R.string.xn_got_it), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            if (noNetClick != null){
                                noNetClick.onPositiveClick();
                            }
                        }
                    })
                    .setCanceledOnTouchOutside(false)
                    .show();
            TextView note = promptDialog.findViewById(R.id.note);
            note.setText(context.getRS(R.string.xn_privacy_no_net, ""));
            TextView urlTextView = promptDialog.findViewById(R.id.urlTextView);
            urlTextView.setText(url);
            urlTextView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        Uri uri = Uri.parse(url);
                        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                        context.startActivity(intent);
                    } catch (Exception e) {
//                        e.printStackTrace();
                    }
                }
            });
            urlTextView.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    ClipboardManager manager = (ClipboardManager)  context.getSystemService(Context.CLIPBOARD_SERVICE);
                    ClipData clipData = ClipData.newPlainText("url",url);
                    manager.setPrimaryClip(clipData);
                    Toast toast = Toast.makeText(context.getApplicationContext(), context.getString(R.string.xn_link_copy), Toast.LENGTH_LONG);
                    toast.setGravity(Gravity.CENTER, 0, 0);
                    toast.show();
                    return true;
                }
            });
        }else {
            if (!promptDialog.isShowing()){
                promptDialog.show();
            }
        }
    }

    public boolean isShow(){
        if (promptDialog != null){
            return promptDialog.isShowing();
        }
        return false;
    }
    public void dismiss(){
        if (promptDialog != null){
            promptDialog.dismiss();
        }
    }
    public interface PrivacyNoNetClick{
        void onPositiveClick();
    }
}