/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.encrypt;

import android.content.Context;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import java.security.InvalidKeyException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class XNKeyStoreManager {
    private static final String KEYSTORE_PROVIDER = "AndroidKeyStore";
    private static final String RSA_MODE = "RSA/ECB/PKCS1Padding";
    private static final String KEYSTORE_ALIAS = "KEYSTORE_TP";
    private static final String charsetName = "UTF-8";
    private KeyStore mKeyStore;

    public XNKeyStoreManager(Context context) {
        try {
            this.mKeyStore = KeyStore.getInstance(KEYSTORE_PROVIDER);
            this.mKeyStore.load(null);
            ClientPrefs prefs = ClientPrefs.get(context);
            if (!prefs.getKeyStoreInit()) {
                this.genKeyStoreKey(context);
                prefs.setKeyStoreInit(true);
                prefs.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void genKeyStoreKey(Context context) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", KEYSTORE_PROVIDER);
        KeyGenParameterSpec keyGenParameterSpec = new KeyGenParameterSpec.Builder(KEYSTORE_ALIAS, 3).setDigests(new String[]{"SHA-256", "SHA-512"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
        keyPairGenerator.generateKeyPair();
    }

    public Cipher getCipher() throws KeyStoreException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException {
        PrivateKey privateKey = (PrivateKey)this.mKeyStore.getKey(KEYSTORE_ALIAS, null);
        Cipher cipher = Cipher.getInstance(RSA_MODE);
        cipher.init(2, privateKey);
        return cipher;
    }

    public String encryptRSA(String value) throws Exception {
        PublicKey publicKey = this.mKeyStore.getCertificate(KEYSTORE_ALIAS).getPublicKey();
        Cipher cipher = Cipher.getInstance(RSA_MODE);
        cipher.init(1, publicKey);
        byte[] encryptedByte = cipher.doFinal(value.getBytes(charsetName));
        return Base64.encodeToString((byte[])encryptedByte, (int)0);
    }

    public byte[] decryptRSA(String encryptedText) throws Exception {
        PrivateKey privateKey = (PrivateKey)this.mKeyStore.getKey(KEYSTORE_ALIAS, null);
        Cipher cipher = Cipher.getInstance(RSA_MODE);
        cipher.init(2, privateKey);
        byte[] encryptedBytes = Base64.decode((String)encryptedText, (int)0);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return decryptedBytes;
    }

    public String decryptRSA(String encryptedText, Cipher cipher) throws Exception {
        byte[] encryptedBytes = Base64.decode((String)encryptedText, (int)0);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return Base64.encodeToString((byte[])decryptedBytes, (int)0);
    }
}

