/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.mvpbase;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public class StatusBarUtil {
    public static int FAKE_STATUS_BAR_VIEW_ID = 16908335;

    public static void setStatusBarColor(Activity activity, int statusBarColor, int navigationBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(activity.getResources().getColor(statusBarColor));
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
            View fakeStatusBarView = decorView.findViewById(FAKE_STATUS_BAR_VIEW_ID);
            if (fakeStatusBarView != null) {
                if (fakeStatusBarView.getVisibility() == 8) {
                    fakeStatusBarView.setVisibility(0);
                }
                fakeStatusBarView.setBackgroundColor(activity.getResources().getColor(statusBarColor));
            } else {
                decorView.addView(StatusBarUtil.createStatusBarView(activity, statusBarColor));
            }
            StatusBarUtil.setRootView(activity);
        }
        int ui = activity.getWindow().getDecorView().getSystemUiVisibility();
        ui = StatusBarUtil.isLightColor(activity.getResources().getColor(statusBarColor)) ? (ui |= 0x2000) : (ui &= 0xFFFFDFFF);
        activity.getWindow().setNavigationBarColor(activity.getResources().getColor(navigationBarColor));
        ui = StatusBarUtil.isLightColor(activity.getResources().getColor(navigationBarColor)) ? (ui |= 0x10) : (ui &= 0xFFFFFFEF);
        activity.getWindow().getDecorView().setSystemUiVisibility(ui);
    }

    private static View createStatusBarView(Activity activity, int color2) {
        View statusBarView = new View((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, StatusBarUtil.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(activity.getResources().getColor(color2));
        statusBarView.setId(FAKE_STATUS_BAR_VIEW_ID);
        return statusBarView;
    }

    private static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    private static void setRootView(Activity activity) {
        ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View childView = parent.getChildAt(i);
            if (!(childView instanceof ViewGroup)) continue;
            childView.setFitsSystemWindows(true);
            ((ViewGroup)childView).setClipToPadding(true);
        }
    }

    private static boolean isLightColor(int color2) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2)) / 255.0;
        return darkness < 0.5;
    }
}

