/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.net;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.mvpbase.BaseData;
import com.transsion.xuanniao.account.comm.net.GlobalHandler;
import com.transsion.xuanniao.account.comm.net.NetWorkProxy;
import com.transsion.xuanniao.account.comm.net.Utils;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.model.data.ApplyKeyReq;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;
import com.transsion.xuanniao.account.model.data.EncryptRes;
import com.transsion.xuanniao.account.model.data.LoginRes;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public abstract class NetCallBack<T>
implements Callback {
    private String tag;
    private Class<T> cl;
    private Context context;
    public static ArrayList<String> encryptFilter = new ArrayList();
    private CipherHelper cipherHelper;
    private int tokenCount = 0;
    private int keyCount = 0;
    private int timeErrorCount = 0;

    public NetCallBack(Context context, String tag, Class<T> cl) {
        this.tag = tag;
        this.cl = cl;
        this.context = context;
    }

    public NetCallBack(Context context, Class<T> cl) {
        this.cl = cl;
        this.context = context;
    }

    public void onFailure(Call call, IOException e) {
        LogUtils.d(call.request().url() + "onFailure IOException response ----->" + e);
        e.printStackTrace();
        BaseData data = new BaseData();
        if (e instanceof SocketTimeoutException) {
            data.code = 1;
            data.message = this.getContext().getString(R.string.xn_request_timeout);
            this.postFailed(data);
        } else {
            data.code = 1;
            data.message = this.getContext().getString(R.string.xn_net_unavailable);
            this.postFailed(data);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onResponse(Call call, Response response) throws IOException {
        try {
            LogUtils.d("onResponse code ----->" + response.code());
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                if (jsonString == null || "".equals(jsonString)) {
                    LogUtils.d(call.request().url() + " response -----> null");
                    this.postSuccess(null);
                    return;
                }
                LogUtils.d(call.request().url() + " response -----> success");
                Gson gson = new Gson();
                boolean isTeeEnable = TeeManager.instance().isTeeEnable();
                boolean isEncrypt = this.isEncrypt(call.request().url().toString());
                if (isTeeEnable && isEncrypt) {
                    EncryptRes encryptRes = (EncryptRes)gson.fromJson(jsonString, EncryptRes.class);
                    if (!encryptRes.checkSign()) {
                        BaseData data = (BaseData)gson.fromJson(jsonString, BaseData.class);
                        data.message = this.getContext().getString(R.string.xn_net_unavailable);
                        this.postFailed(data);
                        return;
                    }
                    jsonString = encryptRes.dataJson(this.cipherHelper);
                    LogUtils.d(" response -----> checkSign success");
                    if (!encryptRes.isSafe(jsonString, this.cipherHelper.getVerifyId())) {
                        LogUtils.d(" response -----> not safe");
                        BaseData data = (BaseData)gson.fromJson(jsonString, BaseData.class);
                        data.message = this.getContext().getString(R.string.xn_net_unavailable);
                        this.postFailed(data);
                        return;
                    }
                } else {
                    LogUtils.d(" response -----> noSign " + isTeeEnable + " " + isEncrypt);
                }
                Object result = gson.fromJson(jsonString, this.cl);
                this.postSuccess(result);
                return;
            }
            if (response.code() == 400) {
                String jsonString = response.body().string();
                LogUtils.d(call.request().url() + " response -----> error param" + response.code() + jsonString);
                Gson gson = new Gson();
                BaseData data = (BaseData)gson.fromJson(jsonString, BaseData.class);
                if (data.code == 400301) {
                    this.applyKey();
                    return;
                }
                if (data.code != 400302) {
                    this.postFailed(data);
                    return;
                }
                if (data.errorExtend == null) return;
                ++this.timeErrorCount;
                long diff = data.errorExtend.currentTime - System.currentTimeMillis();
                if (Math.abs(diff) <= CloudConfigRes.getValidPeriod(this.context)) {
                    diff = 0L;
                }
                ClientPrefs prefs = ClientPrefs.get(this.getContext());
                prefs.setTimeDiff(diff);
                prefs.save();
                this.postRetry();
                if (this.timeErrorCount <= 1) return;
                data.message = this.getContext().getString(R.string.xn_net_unavailable);
                this.postFailed(data);
                this.timeErrorCount = 0;
                return;
            }
            if (response.code() == 401) {
                String jsonString = response.body().string();
                LogUtils.d(call.request().url() + " response ----->" + response.code() + jsonString);
                this.refreshToken();
                return;
            }
            String jsonString = response.body().string();
            Gson gson = new Gson();
            BaseData data = (BaseData)gson.fromJson(jsonString, BaseData.class);
            data.message = this.getContext().getString(R.string.xn_net_unavailable);
            LogUtils.d(call.request().url() + " response ----->" + jsonString);
            this.postFailed(data);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.d(call.request().url() + "Exception response ----->" + e.getMessage());
            BaseData data = new BaseData();
            data.code = response.code();
            data.message = this.getContext().getString(R.string.xn_net_unavailable);
            this.postFailed(data);
        }
    }

    public void postFailed(final BaseData data) {
        if (this.canCallback()) {
            GlobalHandler.getInstance().runInMain(new Runnable(){

                @Override
                public void run() {
                    LogUtils.d("postFailed");
                    NetCallBack.this.onFailed(data, NetCallBack.this.tag);
                }
            });
        }
    }

    public void postSuccess(final T result) {
        if (this.canCallback()) {
            GlobalHandler.getInstance().runInMain(new Runnable(){

                @Override
                public void run() {
                    NetCallBack.this.onSuccess(0, result, NetCallBack.this.tag);
                }
            });
        }
    }

    private void postRetry() {
        if (this.canCallback()) {
            GlobalHandler.getInstance().runInMain(new Runnable(){

                @Override
                public void run() {
                    NetCallBack.this.onRetry();
                }
            });
        }
    }

    private boolean canCallback() {
        if (this.context == null) {
            return false;
        }
        return !(this.context instanceof BaseActivity) || !((BaseActivity)this.context).isFinishing();
    }

    private void postLogin() {
    }

    public abstract void onSuccess(int var1, T var2, String var3);

    public abstract void onRetry();

    public void onFailed(BaseData data, String tag) {
        if (this.context instanceof BaseActivity) {
            ((BaseActivity)this.context).hideWaitDialog();
            if (!TextUtils.isEmpty((CharSequence)data.message)) {
                ((BaseActivity)this.context).warning(data.message);
            }
        }
    }

    private Context getContext() {
        return this.context;
    }

    private void refreshToken() {
        if (this.tokenCount >= 3) {
            return;
        }
        ++this.tokenCount;
        LogUtils.d(" refreshToken");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refreshToken", TeeManager.instance().getRefreshToken());
        NetWorkProxy proxy = new NetWorkProxy(this.context);
        Response response = proxy.requestSyncPost("/sdk/login/refresh-token", params);
        try {
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                LogUtils.d(" refreshToken -----> isSuccessful");
                Gson gson = new Gson();
                LoginRes.SdkToken data = (LoginRes.SdkToken)gson.fromJson(jsonString, LoginRes.SdkToken.class);
                TeeManager.instance().saveToken(data.accessToken, data.refreshToken);
                ClientPrefs prefs = ClientPrefs.get(this.context);
                prefs.setRefreshTime(System.currentTimeMillis());
                prefs.save();
                this.postRetry();
            } else if (response.code() == 400) {
                String jsonString = response.body().string();
                LogUtils.d(" refreshToken -----> ERROR_PARAM" + jsonString);
                Gson gson = new Gson();
                BaseData data = (BaseData)gson.fromJson(jsonString, BaseData.class);
                LogUtils.d(" refreshToken -----> data.code " + data.code);
                if (data.code == 400006) {
                    this.postLogin();
                } else {
                    this.postFailed(data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseData data = new BaseData();
            data.code = response.code();
            data.message = this.getContext().getString(R.string.xn_net_unavailable);
            this.postFailed(data);
            LogUtils.d(" refreshToken ----->" + e.getMessage());
        }
    }

    private void applyKey() {
        if (this.keyCount >= 3) {
            return;
        }
        ++this.keyCount;
        ApplyKeyReq params = new ApplyKeyReq();
        params.publicKey1061 = TeeManager.instance().exportSignatureKey(this.context);
        params.keyId = TeeManager.instance().genKeyId(this.context);
        params.deviceId = Utils.getDeviceId(this.context);
        NetWorkProxy proxy = new NetWorkProxy(this.context);
        Response response = proxy.requestSyncPost("/sdk/config/apply-key", params);
        try {
            if (response.isSuccessful()) {
                LogUtils.d("applyKey -----> isSuccessful");
                this.postRetry();
            } else if (response.code() == 400) {
                String jsonString = response.body().string();
                LogUtils.d(" applyKey -----> ERROR_PARAM" + jsonString);
                Gson gson = new Gson();
                BaseData data = (BaseData)gson.fromJson(jsonString, BaseData.class);
                LogUtils.d(" applyKey -----> data.code " + data.code);
                this.postFailed(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseData data = new BaseData();
            data.code = response.code();
            data.message = this.getContext().getString(R.string.xn_net_unavailable);
            this.postFailed(data);
            LogUtils.d(" applyKey ----->" + e.getMessage());
        }
    }

    public Class<T> getCl() {
        return this.cl;
    }

    public String getTag() {
        return this.tag;
    }

    private boolean isEncrypt(String url) {
        for (int i = 0; i < encryptFilter.size(); ++i) {
            if (!url.contains(encryptFilter.get(i))) continue;
            return true;
        }
        return false;
    }

    public CipherHelper getCipherHelper() {
        return this.cipherHelper;
    }

    public void setCipherHelper(CipherHelper cipherHelper) {
        this.cipherHelper = cipherHelper;
    }

    static {
        encryptFilter.add("/sdk/login/login-by-password-with-captcha-crypt");
        encryptFilter.add("/sdk/account/get-profile-crypt");
        encryptFilter.add("/sdk/account/update-profile-crypt");
        encryptFilter.add("/sdk/account/bind-phone-email-crypt");
        encryptFilter.add("/app/address/list-crypt");
        encryptFilter.add("/app/address/new-crypt");
        encryptFilter.add("/app/address/update-crypt");
        encryptFilter.add("/sdk/login/login-by-third-crypt");
        encryptFilter.add("/sdk/password/new-crypt");
        encryptFilter.add("/sdk/password/reset-crypt");
        encryptFilter.add("/sdk/password/change-crypt");
        encryptFilter.add("/sdk/password/verify-crypt");
        encryptFilter.add("/sdk/verification/verify-code-crypt");
        encryptFilter.add("/client/token-crypt");
    }
}

