/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.net;

import android.content.Context;
import android.text.TextUtils;
import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.net.Utils;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpFactory {
    private static volatile OkHttpFactory sInstance;
    private OkHttpClient client;
    private static final int CONNECT_TIMEOUT = 30;
    private static final int READ_TIMEOUT = 30;
    private Context context;
    private HashMap<String, String> heads;

    private OkHttpFactory(Context context) {
        this.context = context.getApplicationContext();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).addInterceptor(this.getInterceptor());
        this.client = builder.build();
    }

    public void setContent(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static OkHttpFactory getInstance(Context context) {
        if (sInstance == null) {
            Class<OkHttpFactory> clazz = OkHttpFactory.class;
            // MONITORENTER : com.transsion.xuanniao.account.comm.net.OkHttpFactory.class
            if (sInstance == null) {
                sInstance = new OkHttpFactory(context);
            }
            // MONITOREXIT : clazz
        }
        sInstance.setContent(context);
        return sInstance;
    }

    public static OkHttpClient getOkHttpClient(Context context) {
        return OkHttpFactory.getInstance((Context)context).client;
    }

    private Interceptor getInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Request.Builder builder = request.newBuilder();
                HttpUrl url = request.url().newBuilder().build();
                String token = TeeManager.instance().getToken();
                if (TextUtils.isEmpty((CharSequence)token)) {
                    LogUtils.d("OkHttp addHeader token is empty");
                }
                Request newRequest = builder.addHeader("Req-ID", UUID.randomUUID().toString()).addHeader("Client-ID", XNApiManager.instance().getClientId()).addHeader("Device-ID", Utils.getDeviceId(OkHttpFactory.this.context)).addHeader("Client-Data", Utils.params(OkHttpFactory.this.context)).addHeader("Timestamp", String.valueOf(System.currentTimeMillis())).addHeader("Authorization", "Bearer " + token).addHeader("Version-ID", CloudConfigRes.getVersion(OkHttpFactory.this.context)).url(url).build();
                return chain.proceed(newRequest);
            }
        };
    }

    public HashMap<String, String> getHeads() {
        return this.heads;
    }

    public void setHeads(HashMap<String, String> heads) {
        this.heads = heads;
    }
}

