/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.net;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.gson.Gson;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.utils.AppUtils;
import com.transsion.xuanniao.account.comm.utils.FormatUtils;
import com.transsion.xuanniao.account.comm.utils.LanguageUtils;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.UUID;
import tech.palm.lib.utils.CloudUtils;

public class Utils {
    public static String getOsType() {
        return "1";
    }

    public static String getPackageName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.packageName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getVersionCode(Context context, String pkgName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 0);
            return packageInfo.versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getVersionName(Context context, String pkgName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getTimeZone() {
        Calendar now = Calendar.getInstance();
        int offset = now.getTimeZone().getOffset(System.currentTimeMillis()) / 3600000;
        return String.valueOf(offset);
    }

    public static String getSHA1Fingerprint(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        int flags = 64;
        PackageInfo packageInfo = null;
        try {
            packageInfo = pm.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (packageInfo == null) {
            Log.d((String)"AidlUtil", (String)("\u4fe1\u606f\u4e3a null, \u5305\u540d = " + packageName));
            return "";
        }
        Signature[] signatures = packageInfo.signatures;
        byte[] cert = signatures[0].toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(cert);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        X509Certificate c = null;
        try {
            c = (X509Certificate)cf.generateCertificate(input);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        String hexString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(c.getEncoded());
            hexString = Utils.byte2HexFormatted(publicKey);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        return hexString;
    }

    private static String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1) {
                h = "0" + h;
            }
            if (l > 2) {
                h = h.substring(l - 2, l);
            }
            str.append(h.toUpperCase());
            if (i >= arr.length - 1) continue;
            str.append(':');
        }
        return str.toString();
    }

    public static String params(Context context) {
        String pkgName = Utils.getPackageName(context);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gaid", DeviceInfo.getGAId());
        map.put("lang", LanguageUtils.getLocalLanguage(context));
        map.put("timezone", Utils.getTimeZone());
        map.put("osType", Utils.getOsType());
        map.put("pkgName", pkgName);
        map.put("channel", "palmAppOrSdk");
        map.put("pkgSign", Utils.getPkgSign(context, pkgName));
        map.put("version", AppUtils.getVerName(context));
        map.put("deviceNo", Utils.getDeviceNo(context));
        map.put("deviceModel", Utils.getDeviceModel());
        map.put("isNotXuanNiao", true);
        map.put("oneId", "");
        map.put("privacyVersion", ClientPrefs.get(context).getPrivacyVersion());
        map.put("userAgreementVersion", ClientPrefs.get(context).getUserAgreementVersion());
        Gson gson = new Gson();
        return Base64.encodeToString((byte[])gson.toJson(map).getBytes(), (int)2);
    }

    private static String getDeviceModel() {
        return Build.MODEL + "-" + Build.BRAND;
    }

    private static String getDeviceNo(Context context) {
        ClientPrefs prefs = ClientPrefs.get(context);
        if (FormatUtils.isNotEmpty(prefs.getDeviceNo())) {
            return prefs.getDeviceNo();
        }
        String deviceNo = UUID.randomUUID().toString();
        prefs.setDeviceNo(deviceNo);
        prefs.save();
        return deviceNo;
    }

    public static String getPkgSign(Context context, String pkgName) {
        ClientPrefs prefs = ClientPrefs.get(context);
        String sign = prefs.getPkgSign();
        if (TextUtils.isEmpty((CharSequence)sign)) {
            sign = Utils.getSHA1Fingerprint(context, pkgName);
            prefs.setPkgSign(sign);
            prefs.save();
        }
        return sign;
    }

    public static String base64Params(Context context) {
        String params = Utils.params(context);
        return Base64.encodeToString((byte[])params.getBytes(), (int)3);
    }

    public static String getDeviceId(Context context) {
        ClientPrefs prefs = ClientPrefs.get(context);
        String deviceId = prefs.getDeviceId();
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = CloudUtils.getDeviceInfo((Context)context).getDeviceId();
            if (deviceId != null && deviceId.length() < 4) {
                deviceId = "";
            }
            if (TextUtils.isEmpty((CharSequence)deviceId)) {
                deviceId = DeviceInfo.getGAId();
            }
            if (TextUtils.isEmpty((CharSequence)deviceId)) {
                deviceId = UUID.randomUUID().toString();
            }
            prefs.setDeviceId(deviceId);
            prefs.save();
        }
        return deviceId;
    }
}

