/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.prefs;

import android.content.Context;
import android.content.SharedPreferences;

public class BasePrefs {
    private SharedPreferences prefs;
    private SharedPreferences.Editor editor;

    public BasePrefs(Context context, String prefsName) {
        this.prefs = context.getSharedPreferences(prefsName, 0);
    }

    protected boolean getBoolean(String key, boolean defValue) {
        return this.prefs.getBoolean(key, defValue);
    }

    protected float getFloat(String key, float defValue) {
        return this.prefs.getFloat(key, defValue);
    }

    protected int getInt(String key, int defValue) {
        return this.prefs.getInt(key, defValue);
    }

    protected long getLong(String key, long defValue) {
        return this.prefs.getLong(key, defValue);
    }

    public String getString(String key, String defValue) {
        return this.prefs.getString(key, defValue);
    }

    protected void putBoolean(String key, boolean v) {
        this.ensureEditorAvailability();
        this.editor.putBoolean(key, v);
    }

    protected void putFloat(String key, float v) {
        this.ensureEditorAvailability();
        this.editor.putFloat(key, v);
    }

    protected void putInt(String key, int v) {
        this.ensureEditorAvailability();
        this.editor.putInt(key, v);
    }

    protected void putLong(String key, long v) {
        this.ensureEditorAvailability();
        this.editor.putLong(key, v);
    }

    public void putString(String key, String v) {
        this.ensureEditorAvailability();
        this.editor.putString(key, v);
    }

    public void save() {
        if (this.editor != null) {
            this.editor.apply();
        }
    }

    protected void ensureEditorAvailability() {
        if (this.editor == null) {
            this.editor = this.prefs.edit();
        }
    }

    public void clear() {
        this.ensureEditorAvailability();
        this.editor.clear();
        this.save();
    }

    public void remove(String key) {
        this.ensureEditorAvailability();
        this.editor.remove(key);
    }
}

