/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.prefs;

import android.content.Context;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.prefs.BasePrefs;
import org.json.JSONObject;

public class ClientPrefs
extends BasePrefs {
    private static final String PREFS_NAME = "AccountPrefs";
    private final String PKG_SIGN = "pkg_sign";
    private final String IS_LOGGED_IN = "is_logged_in";
    private final String DEVICE_NO = "device_no";
    private final String COUNTRY_CODE = "country_code";
    private final String COUNTRY_NAME = "country_name";
    private final String LOGIN_NAME = "login_name";
    private final String LAST_LOGIN_REQ = "last_login_req";
    private final String ACCOUNT_INFO = "account_info";
    private final String TOKEN_CONFIG = "token_config";
    private final String READ_QUICK = "read_quick";
    private final String KEY_PRIVACY_VERSION = "privacy_version";
    private final String KEY_USER_AGREEMENT_VERSION = "user_agreement_version";
    private final String KEY_PRIVACY_NEED_AGREE = "privacy_need_agree";
    private final String KEY_CLOSE_QUICK = "key_close_quick";
    private final String KEY_VERIFY_PWD_LIMIT = "key_verify_pwd_limit";
    private final String KEY_LOGIN_PWD_LIMIT = "key_login_pwd_limit";
    private final String KEY_CAPTCHA_LIMIT_LOGIN = "key_captcha_limit_login";
    private final String KEY_CAPTCHA_LIMIT_BIND = "key_captcha_limit_bind";
    private final String KEY_CAPTCHA_LIMIT_VERIFY = "key_captcha_limit_verify";
    private final String KEY_CAPTCHA_LIMIT_RESET_PWD = "key_captcha_limit_reset_pwd";
    private final String KEY_CLOUD_CONFIG = "key_cloud_config";
    private final String KEY_IS_LOGIN_TIME_OUT = "is_login_time_out";
    private final String KEY_LOGIN_TIME_OUT = "login_time_out";
    private final String KEY_BINDING_EMAIL_COUNT = "key_binding_email_count";
    private final String KEY_BINDING_PHONE_COUNT = "key_binding_phone_count";
    private final String KEY_LOGIN_COUNT = "key_login_count";
    private final String KEY_VERIFY_ACCOUNT = "key_verify_account";
    private final String KEY_VERIFY_EMAIL = "key_verify_email";
    private final String KEY_VERIFY_PHONE = "key_verify_phone";
    private final String KEY_TIME_DIFF = "key_time_diff";
    private final String KEY_STORE_INIT = "key_store_init";
    private final String KEY_DEVICE_ID = "key_device_id";
    private final String KEY_REFRESH_TIME = "key_refresh_time";
    private final String KEY_TUDC_RELOGIN = "key_tudc_relogin";
    private final String KEY_HAVE_AGREE_BRAND = "have_agree_brand";
    private final String KEY_SMS_TICKET = "sms_ticket";
    private final String KEY_EMS_TICKET = "ems_ticket";
    private Context context;

    public ClientPrefs(Context context, String prefsName) {
        super(context, prefsName);
        this.context = context;
    }

    public static ClientPrefs get(Context context) {
        return new ClientPrefs(context.getApplicationContext(), PREFS_NAME);
    }

    public String getLoginName() {
        return this.getString("login_name", "loginName");
    }

    public String getPkgSign() {
        return this.getString("pkg_sign", "");
    }

    public void setPkgSign(String v) {
        this.putString("pkg_sign", v);
    }

    public boolean getReadQuick() {
        if (!XNApiManager.instance().isPalmIdApp()) {
            return true;
        }
        return this.getBoolean("read_quick", false);
    }

    public void setReadQuick(boolean v) {
        this.putBoolean("read_quick", v);
    }

    public boolean getIsLoggedIn() {
        return this.getBoolean("is_logged_in", false);
    }

    public void setIsLoggedIn(boolean v) {
        this.putBoolean("is_logged_in", v);
    }

    public boolean getHaveAgreeBrand() {
        return this.getBoolean("have_agree_brand", false);
    }

    public void setHaveAgreeBrand(boolean v) {
        this.putBoolean("have_agree_brand", v);
    }

    public String getLastLoginReq() {
        return this.getString("last_login_req", "");
    }

    public void setLastLoginReq(int loginType, String account, int codeType) {
        String lastLoginReq = "";
        try {
            lastLoginReq = new JSONObject().put("lt", loginType).put("ac", (Object)account).put("ct", codeType).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.putString("last_login_req", lastLoginReq);
    }

    public String getDeviceNo() {
        return this.getString("device_no", null);
    }

    public void setDeviceNo(String v) {
        this.putString("device_no", v);
    }

    public String getCountryCode() {
        return this.getString("country_code", "");
    }

    public void setCountryCode(String v) {
        this.putString("country_code", v);
    }

    public String getCountryName() {
        return this.getString("country_name", "");
    }

    public void setCountryName(String v) {
        this.putString("country_name", v);
    }

    public String getAccountInfo() {
        return this.getString("account_info", "");
    }

    public void setAccountInfo(String accountInfo) {
        this.putString("account_info", accountInfo);
    }

    public String getTokenConfig() {
        return this.getString("token_config", "");
    }

    public void setTokenConfig(String config) {
        this.putString("token_config", config);
    }

    public String getPrivacyVersion() {
        return this.getString("privacy_version", this.context.getString(R.string.xn_privacy_version));
    }

    public void setPrivacyVersion(String v) {
        this.putString("privacy_version", v);
    }

    public String getUserAgreementVersion() {
        return this.getString("user_agreement_version", this.context.getString(R.string.xn_user_agreement_version));
    }

    public void setUserAgreementVersion(String v) {
        this.putString("user_agreement_version", v);
    }

    public boolean getCloseQuick() {
        return this.getBoolean("key_close_quick", false);
    }

    public void setCloseQuick(boolean v) {
        this.putBoolean("key_close_quick", v);
    }

    public void setVerifyPwdLimit(long v) {
        this.putLong("key_verify_pwd_limit", v);
    }

    public long getVerifyPwdLimit() {
        return this.getLong("key_verify_pwd_limit", 0L);
    }

    public void setLoginPwdLimit(long v) {
        this.putLong("key_login_pwd_limit", v);
    }

    public long getLoginPwdLimit() {
        return this.getLong("key_login_pwd_limit", 0L);
    }

    public void setCaptchaLoginLimit(long v) {
        this.putLong("key_captcha_limit_login", v);
    }

    public long getCaptchaLoginLimit() {
        return this.getLong("key_captcha_limit_login", 0L);
    }

    public void setCaptchaVerifyLimit(long v) {
        this.putLong("key_captcha_limit_verify", v);
    }

    public long getCaptchaVerifyLimit() {
        return this.getLong("key_captcha_limit_verify", 0L);
    }

    public void setCaptchaResetPwdLimit(long v) {
        this.putLong("key_captcha_limit_reset_pwd", v);
    }

    public long getCaptchaResetPwdLimit() {
        return this.getLong("key_captcha_limit_reset_pwd", 0L);
    }

    public void setCaptchaBindLimit(long v) {
        this.putLong("key_captcha_limit_bind", v);
    }

    public long getCaptchaBindLimit() {
        return this.getLong("key_captcha_limit_bind", 0L);
    }

    public String getCloudConfig() {
        return this.getString("key_cloud_config", "");
    }

    public void setCloudConfig(String v) {
        this.putString("key_cloud_config", v);
    }

    public boolean getIsLoginTimeOut() {
        return this.getBoolean("is_login_time_out", false);
    }

    public void setIsLoginTimeOut(boolean v) {
        this.putBoolean("is_login_time_out", v);
    }

    public void setLoginTimeOut(long v) {
        this.putLong("login_time_out", v);
    }

    public long getLoginTimeOut() {
        return this.getLong("login_time_out", 0L);
    }

    public void setBindingEmailCount(long v) {
        this.putLong("key_binding_email_count", v);
    }

    public long getBindingEmailCount() {
        return this.getLong("key_binding_email_count", 0L);
    }

    public void setBindingPhoneCount(long v) {
        this.putLong("key_binding_phone_count", v);
    }

    public long getBindingPhoneCount() {
        return this.getLong("key_binding_phone_count", 0L);
    }

    public void setLoginCount(long v) {
        this.putLong("key_login_count", v);
    }

    public long getLoginCount() {
        return this.getLong("key_login_count", 0L);
    }

    public void setVerifyAccount(long v) {
        this.putLong("key_verify_account", v);
    }

    public long getVerifyAccount() {
        return this.getLong("key_verify_account", 0L);
    }

    public void setVerifyEmail(long v) {
        this.putLong("key_verify_email", v);
    }

    public long getVerifyEmail() {
        return this.getLong("key_verify_email", 0L);
    }

    public void setVerifyPhone(long v) {
        this.putLong("key_verify_phone", v);
    }

    public long getVerifyPhone() {
        return this.getLong("key_verify_phone", 0L);
    }

    public void setTimeDiff(long v) {
        this.putLong("key_time_diff", v);
    }

    public long getTimeDiff() {
        return this.getLong("key_time_diff", 0L);
    }

    public void setKeyStoreInit(boolean v) {
        this.putBoolean("key_store_init", v);
    }

    public boolean getKeyStoreInit() {
        return this.getBoolean("key_store_init", false);
    }

    public void setDeviceId(String v) {
        this.putString("key_device_id", v);
    }

    public String getDeviceId() {
        return this.getString("key_device_id", "");
    }

    public long getRefreshTime() {
        return this.getLong("key_refresh_time", 0L);
    }

    public void setRefreshTime(long timestamp) {
        this.putLong("key_refresh_time", timestamp);
    }

    public void setTudcRelogin(boolean result) {
        this.putBoolean("key_tudc_relogin", result);
    }

    public boolean getTudcRelogin() {
        return this.getBoolean("key_tudc_relogin", false);
    }

    public void setSMSTicket(String v) {
        this.putString("sms_ticket", v);
    }

    public String getSMSTicket() {
        return this.getString("sms_ticket", "");
    }

    public void setEMSTicket(String v) {
        this.putString("ems_ticket", v);
    }

    public String getEMSTicket() {
        return this.getString("ems_ticket", "");
    }
}

