/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.tee;

import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherHelper {
    private String verifyId;
    private final String algo;
    private final byte[] key;
    private final byte[] iv;

    public CipherHelper(String algo, byte[] key, byte[] iv) {
        this.algo = algo;
        this.key = key;
        this.iv = iv;
    }

    public CipherHelper(String algo, String hexKey, String hexIV) {
        this.algo = algo;
        this.key = CipherHelper.fromHex(hexKey);
        this.iv = CipherHelper.fromHex(hexIV);
    }

    public static CipherHelper init() {
        return new CipherHelper("AES/CBC/PKCS5Padding", "d3808864c571656c77dc794e36fbecf4", "36ee63f993bddcf25162ec14f89a0859");
    }

    private static int fromHex(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException("must be hex!");
    }

    public static byte[] fromHex(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("length must be even!");
        }
        byte[] bin = new byte[hex.length() / 2];
        for (int i = 0; i < bin.length; ++i) {
            bin[i] = (byte)(CipherHelper.fromHex(hex.charAt(i * 2)) << 4 | CipherHelper.fromHex(hex.charAt(i * 2 + 1)));
        }
        return bin;
    }

    public byte[] encrypt(byte[] data) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(this.algo);
            cipher.init(1, (Key)key, iv);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public String encryptAndBase64(byte[] data) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(this.algo);
            cipher.init(1, (Key)key, iv);
            return RSAEncryptUtil.base64Encode(cipher.doFinal(data));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public byte[] decrypt(byte[] data) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.key, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(this.algo);
            cipher.init(2, (Key)key, iv);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public byte[] encrypt(String data) throws Exception {
        return this.encrypt(data.getBytes("utf-8"));
    }

    public byte[] requestKey() {
        byte[] request = new byte[this.key.length + this.iv.length];
        System.arraycopy(this.key, 0, request, 0, this.key.length);
        System.arraycopy(this.iv, 0, request, this.key.length, this.iv.length);
        return request;
    }

    public String getVerifyId() {
        return this.verifyId;
    }

    public void setVerifyId(String verifyId) {
        this.verifyId = verifyId;
    }
}

