/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.tee;

import android.content.Context;
import com.transsion.security.api.hap.TranCryptoManagerLite;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import com.transsion.xuanniao.account.comm.utils.Sha256Utils;
import hyperion.hap.ICryptoManager;
import java.util.List;

public class LiteKeyManager {
    public final String signatureAlias1031 = "signatureAliasTemp";
    public final String signatureAlias = "signatureAlias";
    public final int signatureType = 1061;
    public final int signatureType1031 = 1031;

    private LiteKeyManager() {
    }

    public static LiteKeyManager instance() {
        return SingletonInnerHolder.instance;
    }

    public boolean isAliasNotExist(Context context) {
        List aliases = this.getCryptoManager(context).aliases();
        return aliases == null || !aliases.contains("signatureAlias");
    }

    public void generateSignatureKey(Context context) {
        this.getCryptoManager(context).generateKey("signatureAlias", 1061);
        LogUtils.d("generateSignatureKey");
    }

    public String exportSignatureKey(Context context) {
        byte[] key = this.getCryptoManager(context).exportKey("signatureAlias");
        if (this.isAliasNotExist(context)) {
            this.generateSignatureKey(context);
            key = this.getCryptoManager(context).exportKey("signatureAlias");
        }
        if (key != null) {
            return RSAEncryptUtil.base64Encode(key);
        }
        return "";
    }

    public String genKeyId(Context context) {
        byte[] key = this.getCryptoManager(context).exportKey("signatureAlias");
        if (this.isAliasNotExist(context)) {
            this.generateSignatureKey(context);
            key = this.getCryptoManager(context).exportKey("signatureAlias");
        }
        if (key != null) {
            return Sha256Utils.getSha256FromBytes(key);
        }
        return "";
    }

    private ICryptoManager getCryptoManager(Context context) {
        return (ICryptoManager)TranCryptoManagerLite.Companion.getInstance((Object)context.getApplicationContext());
    }

    static class SingletonInnerHolder {
        public static LiteKeyManager instance = new LiteKeyManager();

        SingletonInnerHolder() {
        }
    }
}

