/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.List;

public class FileUtil {
    public static void grantCropUriPermission(Context context, Uri uri, Intent intent) {
        try {
            List resInfoList = context.getPackageManager().queryIntentActivities(intent, 65536);
            if (resInfoList.isEmpty()) {
                return;
            }
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                context.grantUriPermission(packageName, uri, 3);
            }
        }
        catch (Exception e) {
            LogUtils.d(Log.getStackTraceString((Throwable)e));
        }
    }

    public static void deleteDirWithFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            FileUtil.deleteDirWithFile(file);
        }
        dir.delete();
    }

    public static String readTxtFile(String strFilePath) {
        StringBuilder content = new StringBuilder();
        File file = new File(strFilePath);
        if (file.isDirectory()) {
            LogUtils.d(strFilePath + ",The File doesn't not exist.");
        } else {
            try {
                String line;
                FileInputStream inputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader buffReader = new BufferedReader(inputStreamReader);
                while ((line = buffReader.readLine()) != null) {
                    content.append(line);
                }
                ((InputStream)inputStream).close();
            }
            catch (FileNotFoundException e) {
                LogUtils.d(strFilePath + ",The File doesn't not exist.");
            }
            catch (IOException e) {
                LogUtils.d(e.getMessage());
            }
        }
        return content.toString();
    }

    public static void writeTxtToFile(String strContent, String filePath, String fileName) {
        FileUtil.makeFilePath(filePath, fileName);
        String strFilePath = filePath + "/" + fileName;
        try {
            File file = new File(strFilePath);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            raf.setLength(0L);
            raf.write(strContent.getBytes());
            raf.close();
        }
        catch (Exception e) {
            LogUtils.d("Error on write File:" + e);
        }
    }

    public static File makeFilePath(String filePath, String fileName) {
        File file = null;
        FileUtil.makeRootDirectory(filePath);
        try {
            file = new File(filePath + fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void makeRootDirectory(String filePath) {
        File file = null;
        try {
            file = new File(filePath);
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception e) {
            LogUtils.d(e + "");
        }
    }
}

