/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.xuanniao.account.R;

public class NetUtils {
    public static final String NETWORN_NONE = "none";
    public static final String NETWORN_WIFI = "wifi";
    public static final String NETWORN_2G = "2G";
    public static final String NETWORN_3G = "3G";
    public static final String NETWORN_4G = "4G";
    public static final String NETWORN_MOBILE = "5G";
    private PromptDialog promptDialog;

    private NetUtils() {
    }

    public static NetUtils instance() {
        return SingletonInnerHolder.instance;
    }

    public boolean isNetworkConnected(Context context) {
        if (context != null) {
            block6: {
                ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
                if (cm == null) {
                    return false;
                }
                try {
                    if (Build.VERSION.SDK_INT >= 23) {
                        NetworkCapabilities networkCapabilities;
                        Network activeNetwork = cm.getActiveNetwork();
                        if (activeNetwork != null && (networkCapabilities = cm.getNetworkCapabilities(activeNetwork)) != null) {
                            return networkCapabilities.hasTransport(1) || networkCapabilities.hasTransport(0) || networkCapabilities.hasTransport(4) || networkCapabilities.hasTransport(3);
                        }
                        break block6;
                    }
                    NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                    return networkInfo != null && networkInfo.isConnected();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        return false;
    }

    public void showSetNet(final Context context) {
        if (this.promptDialog == null || !this.promptDialog.isShowing()) {
            this.promptDialog = new PromptDialog.Builder(context, R.style.dialog_soft_input).setTitle((CharSequence)context.getString(R.string.xn_no_net)).setMessage((CharSequence)context.getString(R.string.xn_set_net_note)).setPositiveButton((CharSequence)context.getString(R.string.xn_set_net), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent wifiSettingsIntent = new Intent("android.settings.WIFI_SETTINGS");
                    context.startActivity(wifiSettingsIntent);
                }
            }).setNegativeButton((CharSequence)context.getString(R.string.xn_cancel), null).create();
        }
        if (!this.promptDialog.isShowing()) {
            this.promptDialog.show();
        }
    }

    public void resetDialog() {
        if (this.promptDialog != null && this.promptDialog.isShowing()) {
            this.promptDialog.dismiss();
        }
    }

    public String getNetworkType(Context context) {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (null == connManager) {
            return NETWORN_NONE;
        }
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return NETWORN_NONE;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return NETWORN_WIFI;
        }
        NetworkInfo networkInfo = connManager.getNetworkInfo(0);
        if (null != networkInfo) {
            NetworkInfo.State state2 = networkInfo.getState();
            String strSubTypeName = networkInfo.getSubtypeName();
            if (null != state2 && (state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING)) {
                switch (activeNetInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return NETWORN_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return NETWORN_3G;
                    }
                    case 13: {
                        return NETWORN_4G;
                    }
                }
                if (strSubTypeName.equalsIgnoreCase("TD-SCDMA") || strSubTypeName.equalsIgnoreCase("WCDMA") || strSubTypeName.equalsIgnoreCase("CDMA2000")) {
                    return NETWORN_3G;
                }
                return NETWORN_MOBILE;
            }
        }
        return NETWORN_NONE;
    }

    static class SingletonInnerHolder {
        static NetUtils instance = new NetUtils();

        SingletonInnerHolder() {
        }
    }
}

