/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.core.content.FileProvider;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import java.io.File;
import tech.palm.lib.utils.CommonUtils;

public class OSUtils {
    public static boolean isOldPalmID = false;

    public static Intent getAppDetailSettingIntent(Context context) {
        Intent localIntent = new Intent();
        localIntent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction("android.intent.action.VIEW");
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
        }
        return localIntent;
    }

    public static String getMcc(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            if (null == tm) {
                return "";
            }
            String result = tm.getSimOperator();
            if (result != null && result.length() >= 3) {
                return result.substring(0, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getBrand() {
        String osType = CommonUtils.SystemPropertiesGet((String)"ro.tranos.type");
        String brand = Build.BRAND;
        if (TextUtils.isEmpty((CharSequence)osType)) {
            if ("Infinix".equalsIgnoreCase(brand)) {
                return "Infinix";
            }
            if ("itel".equalsIgnoreCase(brand)) {
                return "itel";
            }
            if ("TECNO".equalsIgnoreCase(brand)) {
                return "TECNO";
            }
            if ("VIMOQ".equalsIgnoreCase(brand)) {
                return "VIMOQ";
            }
        } else {
            if ("xos".equalsIgnoreCase(osType) && "Infinix".equalsIgnoreCase(brand)) {
                return "Infinix";
            }
            if ("itel".equalsIgnoreCase(osType)) {
                if ("VIMOQ".equalsIgnoreCase(brand)) {
                    return "VIMOQ";
                }
                if ("itel".equalsIgnoreCase(brand)) {
                    return "itel";
                }
            } else if ("hios".equalsIgnoreCase(osType) && "TECNO".equalsIgnoreCase(brand)) {
                return "TECNO";
            }
        }
        return "";
    }

    public static String getBrandId() {
        String osType = CommonUtils.SystemPropertiesGet((String)"ro.tranos.type");
        String brand = Build.BRAND;
        if (TextUtils.isEmpty((CharSequence)osType)) {
            if ("Infinix".equalsIgnoreCase(brand)) {
                return "Infinix ID";
            }
            if ("itel".equalsIgnoreCase(brand)) {
                return "itel ID";
            }
            if ("VIMOQ".equalsIgnoreCase(brand)) {
                return "VIMOQ ID";
            }
            if ("TECNO".equalsIgnoreCase(brand)) {
                return "TECNO ID";
            }
        } else {
            if ("xos".equalsIgnoreCase(osType) && "Infinix".equalsIgnoreCase(brand)) {
                return "Infinix ID";
            }
            if ("itel".equalsIgnoreCase(osType)) {
                if ("VIMOQ".equalsIgnoreCase(brand)) {
                    return "VIMOQ ID";
                }
                if ("itel".equalsIgnoreCase(brand)) {
                    return "itel ID";
                }
            } else if ("hios".equalsIgnoreCase(osType) && "TECNO".equalsIgnoreCase(brand)) {
                return "TECNO ID";
            }
        }
        return "TECNO ID";
    }

    public static synchronized Drawable getAppDrawable(Context context, String packageName) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        Drawable drawable = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        if (applicationInfo != null) {
            drawable = packageManager.getApplicationIcon(applicationInfo);
        }
        return drawable;
    }

    public static boolean sDCardAvailable(Context context) {
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) != null;
    }

    public static boolean isRtl(Context context) {
        return context.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    public static Uri getFromFileProvider(Context context, String authority, File file) {
        try {
            return FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toBrandUrl(String url) {
        String brandId = OSUtils.toBrandId();
        if (!TextUtils.isEmpty((CharSequence)brandId)) {
            return url.replace("legal-agreement", brandId + "/legal-agreement");
        }
        return url;
    }

    public static String toBrandId() {
        if (isOldPalmID) {
            return "";
        }
        String brandId = "infinix-id";
        String linkedBrandId = TeeManager.instance().getLinkedBrandId();
        LogUtils.d("lbd = " + linkedBrandId);
        if (!TextUtils.isEmpty((CharSequence)linkedBrandId)) {
            if ("itel ID".equalsIgnoreCase(linkedBrandId)) {
                brandId = "itel-id";
            } else if ("TECNO ID".equalsIgnoreCase(linkedBrandId)) {
                brandId = "tecno-id";
            } else if ("VIMOQ ID".equalsIgnoreCase(linkedBrandId)) {
                brandId = "vimoq-id";
            }
        } else {
            String brand = OSUtils.getBrand();
            if (!TextUtils.isEmpty((CharSequence)brand)) {
                if ("itel".equalsIgnoreCase(brand)) {
                    brandId = "itel-id";
                } else if ("TECNO".equalsIgnoreCase(brand)) {
                    brandId = "tecno-id";
                } else if ("VIMOQ".equalsIgnoreCase(brand)) {
                    brandId = "vimoq-id";
                }
            }
        }
        return brandId;
    }

    public static String toBrandId(String src) {
        if (isOldPalmID) {
            return src.replace("TECNO", "Palm");
        }
        String linkedBrandId = TeeManager.instance().getLinkedBrandId();
        LogUtils.d("lbd = " + linkedBrandId);
        if (!TextUtils.isEmpty((CharSequence)linkedBrandId)) {
            return src.replace("TECNO", linkedBrandId.split(" ")[0]);
        }
        String brand = OSUtils.getBrand();
        return TextUtils.isEmpty((CharSequence)brand) ? src.replace("TECNO", "Infinix") : src.replace("TECNO", brand);
    }

    public static String toBrandId(String src, String brand) {
        if (TextUtils.isEmpty((CharSequence)brand)) {
            return OSUtils.toBrandId(src);
        }
        return src.replace("TECNO", brand);
    }

    public static boolean isOldPalmID(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo("tech.palm.id", 128);
            String metaData = appInfo.metaData.getString("com.palm.id.clientId");
            isOldPalmID = metaData == null || metaData.length() == 0;
            return isOldPalmID;
        }
        catch (Exception exception) {
            isOldPalmID = false;
            return false;
        }
    }
}

