/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.BidiFormatter;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.widget.CustomClickListener;
import tech.palm.lib.athena.AthenaImpl;

public class AccountInput
extends FrameLayout {
    private EditText edit;
    private RelativeLayout accountLeftL;
    private TextView cc;
    private IAccountInputListener inputListener;
    private boolean isSupportUserName;
    private ImageView logo;
    private PopupWindow emailAssociation;
    private boolean isSelectAssociation;
    private EditFocus editFocus;
    private BidiFormatter bidiFormatter;
    private boolean canShowPopView = false;
    private int beforeCount;
    private final Watch watch = new Watch();

    public AccountInput(@NonNull Context context) {
        super(context);
    }

    public AccountInput(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.xn_account_input, (ViewGroup)this, true);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        this.initView();
        this.bidiFormatter = BidiFormatter.getInstance();
    }

    private void initAttr(TypedArray array) {
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = this.findViewById(R.id.line);
        lineView.setVisibility(showLine ? 0 : 4);
        if (hint != null && !hint.isEmpty()) {
            EditText phoneEdit = (EditText)this.findViewById(R.id.edit);
            phoneEdit.setHint((CharSequence)hint);
        }
        array.recycle();
    }

    private void initView() {
        this.edit = (EditText)this.findViewById(R.id.edit);
        this.accountLeftL = (RelativeLayout)this.findViewById(R.id.accountLeftL);
        this.cc = (TextView)this.findViewById(R.id.cc);
        this.logo = (ImageView)this.findViewById(R.id.logo);
        this.cc.setOnClickListener((View.OnClickListener)new Click());
        this.edit.setOnFocusChangeListener((View.OnFocusChangeListener)new FocusListener());
        this.edit.addTextChangedListener((TextWatcher)this.watch);
    }

    public void setHint(String hint) {
        this.edit.setHint((CharSequence)hint);
    }

    public String getText() {
        return this.edit.getText().toString();
    }

    public void setCc(String text) {
        this.cc.setText((CharSequence)this.bidiFormatter.unicodeWrap(text, TextDirectionHeuristics.LTR));
        if (TextUtils.isEmpty((CharSequence)text) || TextUtils.isEmpty((CharSequence)text.trim())) {
            return;
        }
        if (text.trim().length() >= 5) {
            this.cc.setTextSize(2, 12.0f);
        } else {
            this.cc.setTextSize(2, 14.0f);
        }
    }

    public String getCc() {
        return this.cc.getText().toString();
    }

    public void setText(String text) {
        if (this.isEmail(text)) {
            this.edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(100)});
        } else if (this.isPhone(text)) {
            this.edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(15)});
        } else {
            this.edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(50)});
        }
        this.edit.setText((CharSequence)text);
        Editable b = this.edit.getText();
        this.edit.setSelection(b.length());
    }

    public void addWatch(TextWatcher watcher) {
        this.edit.addTextChangedListener(watcher);
    }

    public void setInputListener(IAccountInputListener inputListener) {
        this.inputListener = inputListener;
    }

    public boolean isSupportUserName() {
        return this.isSupportUserName;
    }

    public void setSupportUserName(boolean supportUserName) {
        this.isSupportUserName = supportUserName;
        this.identifyAccountType(2);
    }

    public int getType() {
        if (this.isPhone(this.getText())) {
            return 3;
        }
        if (this.isEmail(this.getText())) {
            return 2;
        }
        return 1;
    }

    public void showEmailAssociation() {
    }

    public void hideEmailAssociation() {
    }

    public boolean isShowEmailAssociation() {
        if (this.emailAssociation != null) {
            return this.emailAssociation.isShowing();
        }
        return false;
    }

    public EditText getEdit() {
        return this.edit;
    }

    public boolean isCanShowPopView() {
        return this.canShowPopView;
    }

    public void setCanShowPopView(boolean canShowPopView) {
        this.canShowPopView = canShowPopView;
    }

    public void setOnlyPhoneNum() {
        this.edit.setHint(R.string.xn_phone_num);
        this.edit.setInputType(3);
        this.edit.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)"0123456789"));
        this.edit.removeTextChangedListener((TextWatcher)this.watch);
        this.logo.setVisibility(8);
        this.accountLeftL.setVisibility(0);
    }

    public void setLogoColor(boolean hasFocus) {
        AppCompatImageView logo = (AppCompatImageView)this.findViewById(R.id.logo);
        Drawable drawable2 = logo.getDrawable();
        drawable2.setTint(this.getResources().getColor(hasFocus ? R.color.xn_input_logo_color_s : R.color.xn_input_logo_color, null));
        this.cc.setTextAppearance(hasFocus ? R.style.font_black_14 : R.style.font_black_14_t40);
    }

    private void identifyAccountType(int changeCount) {
        if (this.isPhone(this.getText())) {
            this.logo.setVisibility(8);
            this.accountLeftL.setVisibility(0);
            if (this.emailAssociation != null && this.emailAssociation.isShowing()) {
                this.emailAssociation.dismiss();
            }
            this.edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(15)});
        } else if (this.isEmail(this.getText())) {
            this.logo.setVisibility(0);
            this.accountLeftL.setVisibility(8);
            this.logo.setImageResource(R.drawable.xn_icon_email);
            if (changeCount <= 1) {
                this.showEmailAssociation();
            }
            this.edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(100)});
            this.setLogoColor(true);
        } else {
            this.logo.setVisibility(0);
            this.accountLeftL.setVisibility(8);
            this.logo.setImageResource(R.drawable.xn_icon_account);
            if (this.emailAssociation != null && this.emailAssociation.isShowing()) {
                this.emailAssociation.dismiss();
            }
            this.edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(50)});
            this.setLogoColor(true);
        }
    }

    public boolean isPhone(String value) {
        if (TextUtils.isEmpty((CharSequence)value) || value.length() < 3) {
            return false;
        }
        String rule = "[0-9]+";
        return value.matches(rule);
    }

    private boolean isEmail(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        if (this.isSupportUserName) {
            return value.contains("@");
        }
        return !this.isNum(value);
    }

    private boolean isNum(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        String rule = "[0-9]+";
        return value.matches(rule);
    }

    private boolean isAccount(String value) {
        if (!this.isSupportUserName || TextUtils.isEmpty((CharSequence)value) || value.length() < 3) {
            return false;
        }
        return !this.isPhone(value) && !this.isEmail(value);
    }

    public void setEditFocus(EditFocus editFocus) {
        this.editFocus = editFocus;
    }

    public static interface EditFocus {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface IAccountInputListener {
        public void onSelectCc();
    }

    class Watch
    implements TextWatcher {
        Watch() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            AccountInput.this.beforeCount = AccountInput.this.getText().length();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            AccountInput.this.identifyAccountType(s.length() - AccountInput.this.beforeCount);
        }
    }

    class Click
    extends CustomClickListener {
        Click() {
        }

        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.cc && AccountInput.this.inputListener != null) {
                AccountInput.this.inputListener.onSelectCc();
            }
        }
    }

    class FocusListener
    implements View.OnFocusChangeListener {
        FocusListener() {
        }

        public void onFocusChange(View v, boolean hasFocus) {
            View line = AccountInput.this.findViewById(R.id.line);
            int colorId = hasFocus ? R.color.os_fill_primary_color : R.color.os_gray_secondary_color;
            line.setBackgroundColor(AccountInput.this.getResources().getColor(colorId));
            line = AccountInput.this.findViewById(R.id.line1);
            line.setBackgroundColor(AccountInput.this.getResources().getColor(colorId));
            if (!hasFocus) {
                if (!AccountInput.this.isSupportUserName && !TextUtils.isEmpty((CharSequence)AccountInput.this.getText())) {
                    String type = AccountInput.this.isPhone(AccountInput.this.getText()) ? "Phone" : "Mail";
                    AthenaImpl.getInstance((Context)AccountInput.this.getContext()).accountFillCl(type, AccountInput.this.getText().length());
                }
                AccountInput.this.hideEmailAssociation();
            }
            AccountInput.this.setLogoColor(hasFocus);
            if (AccountInput.this.editFocus != null) {
                AccountInput.this.editFocus.onFocusChange(v, hasFocus);
            }
        }
    }
}

