/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.transsion.core.utils.ScreenUtil;

public class BehaviorImageView
extends AppCompatImageView {
    private int mRadius;
    private Path mPath;
    private RectF mRectF;
    private ViewOutlineProvider viewOutlineProvider;
    private int mWidth;
    private int mHeight;
    private Paint mSlidePaint;
    private Bitmap mSlideBitmap;
    private float mSlideScale;
    private float mSlideXPos;
    private float mSlideYPos;
    private Matrix mSlideMatrix;
    private int mType = -1;
    private ImageClickListener mClickListener;

    public BehaviorImageView(@NonNull Context context) {
        this(context, null);
    }

    public BehaviorImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BehaviorImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mSlideMatrix = new Matrix();
        this.mSlidePaint = new Paint();
        this.mSlidePaint.setAntiAlias(true);
        this.setRadius(ScreenUtil.dip2px((float)6.0f));
    }

    public void setClickListener(ImageClickListener listener) {
        this.mClickListener = listener;
    }

    public void setRadius(int radius) {
        boolean isChange = radius != this.mRadius;
        this.mRadius = radius;
        if (this.mPath == null) {
            this.mPath = new Path();
        }
        if (this.mRectF == null) {
            this.mRectF = new RectF();
        }
        if (this.mRadius != 0) {
            if (21 <= Build.VERSION.SDK_INT) {
                if (this.viewOutlineProvider == null) {
                    this.viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int width = BehaviorImageView.this.getWidth();
                            int height = BehaviorImageView.this.getHeight();
                            outline.setRoundRect(0, 0, width, height, (float)BehaviorImageView.this.mRadius);
                        }
                    };
                }
                this.setOutlineProvider(this.viewOutlineProvider);
                this.setClipToOutline(true);
            }
            this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRectF, (float)this.mRadius, (float)this.mRadius, Path.Direction.CW);
        } else if (21 <= Build.VERSION.SDK_INT) {
            this.setClipToOutline(false);
        }
        if (isChange && 21 <= Build.VERSION.SDK_INT) {
            this.invalidateOutline();
        }
    }

    public void setData(int type, float slideYPos, Bitmap slideBitmap, Bitmap bgBitmap) {
        this.mType = type;
        this.mSlideBitmap = slideBitmap;
        if (bgBitmap != null) {
            this.mSlideScale = (float)this.mWidth * 1.0f / (float)bgBitmap.getWidth();
            this.mSlideYPos = slideYPos / 100.0f * (float)bgBitmap.getHeight() * this.mSlideScale;
            this.setImageBitmap(bgBitmap);
        } else {
            this.setImageBitmap(null);
        }
    }

    public void setXPos(float xPos) {
        this.mSlideXPos = xPos;
        this.invalidate();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mSlideBitmap != null) {
            this.mSlideMatrix.setScale(this.mSlideScale, this.mSlideScale);
            this.mSlideMatrix.postTranslate(this.mSlideXPos, this.mSlideYPos);
            canvas.drawBitmap(this.mSlideBitmap, this.mSlideMatrix, this.mSlidePaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1 && this.mClickListener != null && this.mType == 0) {
            this.mClickListener.onTouch(event.getX() / (float)this.mWidth, event.getY() / (float)this.mHeight);
        }
        return super.onTouchEvent(event);
    }

    public void layout(int left, int top, int right, int bottom) {
        super.layout(left, top, right, bottom);
        this.mWidth = right - left;
        this.mHeight = bottom - top;
    }

    public void draw(Canvas canvas) {
        boolean clip = false;
        if (21 > Build.VERSION.SDK_INT && this.mRadius > 0) {
            clip = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
        if (clip) {
            canvas.restore();
        }
    }

    public static interface ImageClickListener {
        public void onTouch(float var1, float var2);
    }
}

