/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.customview.widget.ViewDragHelper;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.LogUtils;

public class BehaviorSlideView
extends FrameLayout {
    private BehaviorSlideView mSlideView;
    private ImageView mSlideBlock;
    private ProgressBar mProgressBar;
    private ViewDragHelper mViewDragHelper;
    private SlideListener mSlideListener;
    private boolean isError = false;
    private int mSlideState = 0;
    private boolean isDragEnable = true;

    public BehaviorSlideView(@NonNull Context context) {
        this(context, null);
    }

    public BehaviorSlideView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BehaviorSlideView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this.mSlideView = this;
        this.mViewDragHelper = ViewDragHelper.create((ViewGroup)this, (float)0.2f, (ViewDragHelper.Callback)new ViewDragHelper.Callback(){

            public boolean tryCaptureView(@NonNull View child, int pointerId) {
                return child == BehaviorSlideView.this.mSlideBlock && !BehaviorSlideView.this.isError && BehaviorSlideView.this.isDragEnable;
            }

            public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
                int blockWidth = BehaviorSlideView.this.mSlideBlock.getWidth();
                int fullWidth = BehaviorSlideView.this.mSlideView.getWidth();
                int leftMinDistance = BehaviorSlideView.this.getPaddingStart();
                int leftMaxDistance = fullWidth - BehaviorSlideView.this.getPaddingEnd() - blockWidth;
                if (left < leftMinDistance) {
                    left = leftMinDistance;
                } else if (left > leftMaxDistance) {
                    left = leftMaxDistance;
                }
                if (BehaviorSlideView.this.mProgressBar != null) {
                    BehaviorSlideView.this.mProgressBar.setProgress((left + blockWidth / 2) * 100 / fullWidth);
                }
                if (BehaviorSlideView.this.mSlideListener != null) {
                    BehaviorSlideView.this.mSlideListener.onViewSlide(left);
                }
                return left;
            }

            public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
                return BehaviorSlideView.this.getPaddingTop();
            }

            public void onViewCaptured(@NonNull View capturedChild, int activePointerId) {
                super.onViewCaptured(capturedChild, activePointerId);
            }

            public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
                super.onViewReleased(releasedChild, xvel, yvel);
                int blockLeft = releasedChild.getLeft();
                int fullWidth = BehaviorSlideView.this.mSlideView.getWidth();
                if (BehaviorSlideView.this.mSlideListener != null) {
                    BehaviorSlideView.this.mSlideListener.onViewReleased((float)blockLeft * 1.0f / (float)fullWidth);
                } else {
                    BehaviorSlideView.this.reset();
                }
            }

            public void onViewDragStateChanged(int state) {
                super.onViewDragStateChanged(state);
                LogUtils.d("onViewDragStateChanged state = " + state);
                BehaviorSlideView.this.mSlideState = state;
                if (state == 0 && BehaviorSlideView.this.isError) {
                    BehaviorSlideView.this.resetState();
                }
            }
        });
    }

    private void resetState() {
        this.isError = false;
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgressDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.xn_behavior_progress_normal));
        }
        if (this.mSlideBlock != null) {
            this.mSlideBlock.setImageResource(R.drawable.xn_slide_block_normal);
        }
    }

    public void setSlideListener(SlideListener slideListener) {
        this.mSlideListener = slideListener;
    }

    public void reset() {
        if (this.mViewDragHelper != null) {
            this.mViewDragHelper.smoothSlideViewTo((View)this.mSlideBlock, this.getPaddingStart(), 0);
            this.invalidate();
        }
    }

    public void resetWithError() {
        this.isError = true;
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgressDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.xn_behavior_progress_error));
        }
        if (this.mSlideBlock != null) {
            this.mSlideBlock.setImageResource(R.drawable.xn_slide_block_error);
            if (this.mViewDragHelper != null) {
                boolean continueSliding = this.mViewDragHelper.smoothSlideViewTo((View)this.mSlideBlock, this.getPaddingStart(), 0);
                LogUtils.d("resetWithError continueSliding = " + continueSliding);
                if (continueSliding) {
                    this.invalidate();
                } else {
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (BehaviorSlideView.this.isError) {
                                BehaviorSlideView.this.resetState();
                            }
                        }
                    }, 1000L);
                }
            }
        }
    }

    public boolean isIdle() {
        return this.mSlideState == 0;
    }

    public void setDragEnable(boolean enable) {
        this.isDragEnable = enable;
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        int left = this.mSlideBlock.getLeft();
        int blockWidth = this.mSlideBlock.getWidth();
        int fullWidth = this.getWidth();
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgress((left + blockWidth / 2) * 100 / fullWidth);
        }
        if (this.mSlideListener != null) {
            this.mSlideListener.onViewSlide(left);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mSlideBlock = (ImageView)this.findViewById(R.id.slideBlock);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mViewDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mViewDragHelper.processTouchEvent(event);
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mViewDragHelper != null && this.mViewDragHelper.continueSettling(true)) {
            this.invalidate();
        }
    }

    public static interface SlideListener {
        public void onViewSlide(float var1);

        public void onViewReleased(float var1);
    }
}

