/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.widget.CustomClickListener;

public class BehaviorVerifyInput
extends FrameLayout {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_SUCCESS = 1;
    public static final int STATE_FAILED = 2;
    private int state = 0;
    private RelativeLayout contentL;
    private ImageView ivBehaviorLogo;
    private ImageView ivRefresh;
    private TextView tvBehavior;
    private boolean hasRadiusBg = false;
    private VerifyListener verifyListener;

    public BehaviorVerifyInput(Context context) {
        super(context);
    }

    public BehaviorVerifyInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.xn_view_behavior_input, (ViewGroup)this, true);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        this.initView();
    }

    private void initAttr(TypedArray array) {
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = this.findViewById(R.id.line);
        lineView.setVisibility(showLine ? 0 : 4);
        array.recycle();
    }

    public void setVerifyListener(VerifyListener listener) {
        this.verifyListener = listener;
    }

    public void setState(int newState) {
        this.state = newState;
        View lineView = this.findViewById(R.id.line);
        switch (newState) {
            case 0: {
                if (this.hasRadiusBg) {
                    this.contentL.setBackgroundResource(R.drawable.xn_brand_radius_grey_bg);
                } else {
                    lineView.setBackgroundColor(this.getResources().getColor(R.color.os_gray_secondary_color));
                }
                this.ivRefresh.setVisibility(4);
                this.tvBehavior.setText(R.string.xn_behavior_click);
                this.tvBehavior.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.xn_behavior_verify_normal));
                break;
            }
            case 1: {
                if (this.hasRadiusBg) {
                    this.contentL.setBackgroundResource(R.drawable.xn_brand_radius_green_bg);
                } else {
                    lineView.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_gray_secondary_color));
                }
                this.ivRefresh.setVisibility(4);
                this.tvBehavior.setText(R.string.xn_behavior_success);
                this.tvBehavior.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.xn_behavior_verify_success));
                break;
            }
            case 2: {
                if (this.hasRadiusBg) {
                    this.contentL.setBackgroundResource(R.drawable.xn_brand_radius_red_bg);
                } else {
                    lineView.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_red_basic_color));
                }
                this.ivRefresh.setVisibility(0);
                this.tvBehavior.setText(R.string.xn_behavior_fail);
                this.tvBehavior.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.xn_behavior_verify_fail));
            }
        }
    }

    public int getState() {
        return this.state;
    }

    private void initView() {
        this.contentL = (RelativeLayout)this.findViewById(R.id.contentL);
        this.tvBehavior = (TextView)this.findViewById(R.id.tvBehavior);
        this.tvBehavior.setOnClickListener((View.OnClickListener)new Click());
        this.ivRefresh = (ImageView)this.findViewById(R.id.ivRefresh);
        this.ivRefresh.setOnClickListener((View.OnClickListener)new Click());
        this.setState(this.state);
    }

    public void saveState(Bundle outState) {
        outState.putInt("bv_state", this.state);
        outState.putInt("bv_visibility", this.getVisibility());
    }

    public void restoreState(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey("bv_state")) {
                this.setState(inState.getInt("bv_state"));
            }
            if (inState.containsKey("bv_visibility")) {
                this.setVisibility(inState.getInt("bv_visibility"));
            }
        }
    }

    public static interface VerifyListener {
        public void showVerifyDialog();
    }

    class Click
    extends CustomClickListener {
        Click() {
        }

        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.tvBehavior) {
                if (BehaviorVerifyInput.this.state == 0 && BehaviorVerifyInput.this.verifyListener != null) {
                    BehaviorVerifyInput.this.verifyListener.showVerifyDialog();
                }
            } else if (v.getId() == R.id.ivRefresh && BehaviorVerifyInput.this.verifyListener != null) {
                BehaviorVerifyInput.this.verifyListener.showVerifyDialog();
            }
        }
    }
}

