/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.os.CountDownTimer;

public class CountHelper {
    private CountDownTimer countDownTimer;
    private long millisInFuture = 300000L;
    private long countDownInterval = 1000L;
    private boolean isCounting = false;
    private CountListener listener;

    public CountHelper(CountListener listener) {
        this.listener = listener;
    }

    public void init(long millisInFuture) {
        this.millisInFuture = millisInFuture;
    }

    public void startCount() {
        if (this.countDownTimer == null) {
            this.countDownTimer = new CountDownTimer(this.millisInFuture, this.countDownInterval){

                public void onTick(long millisUntilFinished) {
                    if (CountHelper.this.listener != null) {
                        CountHelper.this.listener.onTick(millisUntilFinished);
                    }
                }

                public void onFinish() {
                    CountHelper.this.isCounting = false;
                    if (CountHelper.this.listener != null) {
                        CountHelper.this.listener.countFinish();
                    }
                }
            };
        }
        this.isCounting = true;
        this.countDownTimer.start();
    }

    public void clearCount() {
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
            this.countDownTimer = null;
        }
        this.isCounting = false;
    }

    public boolean isCounting() {
        return this.isCounting;
    }

    public static interface CountListener {
        public void countFinish();

        public void onTick(long var1);
    }
}

