/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.transsion.xuanniao.account.R;

public class WaitDialog
extends Dialog {
    private String msg;
    private Context context;
    private Animation animation;
    private ImageView circleImg;
    private TextView content;

    public WaitDialog(Context context) {
        super(context, R.style.waitDialog);
        this.context = context;
    }

    public WaitDialog(Context context, int theme) {
        super(context, theme);
        this.context = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.xn_wait_dialog);
        this.circleImg = (ImageView)this.findViewById(R.id.circleImg);
        this.animation = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.wait_rotate);
        this.circleImg.setAnimation(this.animation);
        this.content = (TextView)this.findViewById(R.id.content);
        if (this.msg != null) {
            this.content.setText((CharSequence)this.msg);
        }
        this.setCanceledOnTouchOutside(false);
    }

    private void showAnimation() {
        this.circleImg.setAnimation(this.animation);
        if (this.msg != null) {
            this.content.setText((CharSequence)this.msg);
        }
    }

    public void show() {
        super.show();
        this.showAnimation();
    }

    public void show(String msg) {
        this.msg = msg;
        this.content.setText((CharSequence)msg);
        this.show();
    }

    public void dismiss() {
        super.dismiss();
        this.circleImg.clearAnimation();
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

