/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.login.view;

import android.content.Context;
import android.text.BidiFormatter;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.model.data.CountryData;
import java.util.ArrayList;

public class CountryListAdapter
extends BaseAdapter {
    private ArrayList<CountryData.Country> countries;
    private Context context;
    private OnSelect onSelect;
    private boolean notShowCode = false;
    private boolean isCLick = false;
    private BidiFormatter bidiFormatter;

    public CountryListAdapter(Context context, ArrayList<CountryData.Country> data) {
        this.context = context;
        this.countries = data;
        this.bidiFormatter = BidiFormatter.getInstance();
    }

    public void setNotShowCode(boolean notShowCode) {
        this.notShowCode = notShowCode;
    }

    public void setCountries(ArrayList<CountryData.Country> data) {
        String name = this.getSelectedName();
        this.countries = new ArrayList();
        this.countries.addAll(data);
        this.setSelected(null, name);
        this.notifyDataSetChanged();
    }

    private String getSelectedName() {
        if (this.countries != null) {
            for (int i = 0; i < this.countries.size(); ++i) {
                if (!this.countries.get((int)i).isSelected) continue;
                return this.countries.get((int)i).country;
            }
        }
        return null;
    }

    public int getCount() {
        if (this.countries != null) {
            return this.countries.size();
        }
        return 0;
    }

    public Object getItem(int position) {
        if (this.countries != null) {
            return this.countries.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Holder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.xn_item_country, null, false);
            holder = new Holder();
            holder.name = (TextView)convertView.findViewById(R.id.name);
            holder.code = (TextView)convertView.findViewById(R.id.code);
            holder.radio = (RadioButton)convertView.findViewById(R.id.radio);
            holder.content = (RelativeLayout)convertView.findViewById(R.id.content);
            convertView.setTag((Object)holder);
        }
        holder = (Holder)convertView.getTag();
        CountryData.Country country = this.countries.get(position);
        holder.name.setText((CharSequence)country.displayName);
        if (this.notShowCode) {
            holder.code.setVisibility(4);
        } else {
            holder.code.setText((CharSequence)this.bidiFormatter.unicodeWrap("+" + country.code, TextDirectionHeuristics.LTR));
            holder.code.setVisibility(0);
        }
        holder.radio.setChecked(country.isSelected);
        holder.radio.setTag((Object)position);
        holder.radio.setOnClickListener(v -> this.setSelected(position));
        return convertView;
    }

    public void setSelected(int index) {
        if (!this.countries.get((int)index).isSelected) {
            for (int i = 0; i < this.countries.size(); ++i) {
                this.countries.get((int)i).isSelected = index == i;
            }
            this.isCLick = true;
            this.notifyDataSetChanged();
        }
        if (this.onSelect != null) {
            this.onSelect.select(index);
        }
    }

    public void setSelected(String code, String name) {
        if (TextUtils.isEmpty((CharSequence)code) && TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            for (int i = 0; i < this.countries.size(); ++i) {
                this.countries.get((int)i).isSelected = code.equals(this.countries.get((int)i).code);
            }
        } else {
            String enName = CountryData.getEnName(this.context, name, this.countries);
            if (!TextUtils.isEmpty((CharSequence)enName)) {
                name = enName;
            }
            for (int i = 0; i < this.countries.size(); ++i) {
                this.countries.get((int)i).isSelected = name.equals(this.countries.get((int)i).country);
            }
        }
    }

    public void setOnSelect(OnSelect onSelect) {
        this.onSelect = onSelect;
    }

    public int getSelectIndex() {
        for (int i = 0; i < this.countries.size(); ++i) {
            if (!this.countries.get((int)i).isSelected) continue;
            return i;
        }
        return 0;
    }

    class Holder {
        public TextView name;
        public TextView code;
        public RadioButton radio;
        public RelativeLayout content;

        Holder() {
        }
    }

    public static interface OnSelect {
        public void select(int var1);
    }
}

