/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.login.view;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.transsion.effectengine.bounceeffect.OverScrollDecorHelper;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.login.presenter.CountryPresenter;
import com.transsion.xuanniao.account.login.presenter.ICountryView;
import com.transsion.xuanniao.account.login.view.CountryListAdapter;
import com.transsion.xuanniao.account.model.data.CountryData;
import java.util.ArrayList;

public class CountrySelectActivity
extends BaseActivity
implements ICountryView {
    public static final String KEY_NOT_SHOW_CODE = "notShowCode";
    public static final String KEY_CC = "key_cc";
    public static final String KEY_NAME_EN = "key_name_en";
    public static final String KEY_NAME = "key_name";
    private CountryListAdapter adapter;
    private CountryPresenter presenter;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.xn_activity_country_select);
        this.presenter = new CountryPresenter();
        this.presenter.attachView(this);
        this.presenter.getCountriesFromCache();
        this.initActionBar();
    }

    private void initActionBar() {
        this.getActionBar().setDisplayOptions(16, 26);
        this.getActionBar().setDisplayHomeAsUpEnabled(true);
        this.getActionBar().setCustomView(R.layout.os_actionbar_title_search_layout);
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)this.getActionBar().getCustomView().findViewById(R.id.text_search);
        final ImageView deleteAll = (ImageView)this.getActionBar().getCustomView().findViewById(R.id.img_delete_all);
        boolean showCode = this.getIntent().getBooleanExtra(KEY_NOT_SHOW_CODE, false);
        if (showCode) {
            autoCompleteTextView.setHint((CharSequence)this.getString(R.string.xn_country_region_hint));
        } else {
            autoCompleteTextView.setHint((CharSequence)this.getString(R.string.xn_country_hint));
        }
        autoCompleteTextView.setEllipsize(TextUtils.TruncateAt.valueOf((String)"END"));
        autoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (count >= 0 && s.toString().trim().length() > 0) {
                    deleteAll.setVisibility(0);
                } else {
                    deleteAll.setVisibility(8);
                }
                if (CountrySelectActivity.this.adapter != null) {
                    CountrySelectActivity.this.adapter.setCountries(CountrySelectActivity.this.filter(s.toString()));
                }
            }

            public void afterTextChanged(Editable editable) {
            }
        });
        deleteAll.setOnClickListener(v -> autoCompleteTextView.setText((CharSequence)""));
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void initList(ArrayList<CountryData.Country> countries) {
        ListView listView = (ListView)this.findViewById(R.id.listView);
        this.adapter = new CountryListAdapter((Context)this, countries);
        this.adapter.setNotShowCode(this.getIntent().getBooleanExtra(KEY_NOT_SHOW_CODE, false));
        this.adapter.setSelected(this.getIntent().getStringExtra("countryCode"), this.getIntent().getStringExtra("countryName"));
        listView.setAdapter((ListAdapter)this.adapter);
        listView.setSelection(this.adapter.getSelectIndex());
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CountrySelectActivity.this.adapter.setSelected(position);
            }
        });
        this.adapter.setOnSelect(new CountryListAdapter.OnSelect(){

            @Override
            public void select(int position) {
                CountryData.Country country = (CountryData.Country)CountrySelectActivity.this.adapter.getItem(position);
                Intent intent = new Intent();
                intent.putExtra(CountrySelectActivity.KEY_CC, country.code);
                intent.putExtra(CountrySelectActivity.KEY_NAME, country.displayName);
                intent.putExtra(CountrySelectActivity.KEY_NAME_EN, country.country);
                CountrySelectActivity.this.setResult(-1, intent);
                CountrySelectActivity.this.finish();
            }
        });
        OverScrollDecorHelper.setUpOverScroll((ListView)listView);
    }

    private ArrayList<CountryData.Country> filter(String key) {
        if (this.presenter.getCountries() == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)key)) {
            return this.presenter.getCountries();
        }
        ArrayList<CountryData.Country> content = new ArrayList<CountryData.Country>();
        for (CountryData.Country item : this.presenter.getCountries()) {
            if (!item.displayName.toLowerCase().contains(key.toLowerCase()) && !item.country.toLowerCase().contains(key.toLowerCase()) && !item.code.toLowerCase().contains(key.toLowerCase())) continue;
            content.add(item);
        }
        return content;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void fillDataToPage(ArrayList<CountryData.Country> countries) {
        if (this.adapter == null) {
            this.initList(countries);
        } else {
            this.adapter.setCountries(countries);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.detachView();
        }
    }
}

