/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.login.view;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.util.Log;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.transsion.athenacust.AthenaCust;
import com.transsion.effectengine.bounceeffect.OverScrollDecorHelper;
import com.transsion.palmsdk.auth.PalmAuthManager;
import com.transsion.palmsdk.data.PalmAuthRequest;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.AthenaUtils;
import com.transsion.xuanniao.account.comm.utils.FormatUtil;
import com.transsion.xuanniao.account.comm.utils.FormatUtils;
import com.transsion.xuanniao.account.comm.utils.LanguageUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.comm.utils.OSUtils;
import com.transsion.xuanniao.account.comm.widget.AccountInput;
import com.transsion.xuanniao.account.comm.widget.BehaviorVerifyInput;
import com.transsion.xuanniao.account.comm.widget.CaptchaCodeInput;
import com.transsion.xuanniao.account.comm.widget.CustomClickListener;
import com.transsion.xuanniao.account.comm.widget.ErrorView;
import com.transsion.xuanniao.account.comm.widget.SmsCodeInput;
import com.transsion.xuanniao.account.comm.widget.XNClickableSpan;
import com.transsion.xuanniao.account.comm.widget.XNLinkMovementMethod;
import com.transsion.xuanniao.account.help.view.WebViewActivity;
import com.transsion.xuanniao.account.login.presenter.ILoginView;
import com.transsion.xuanniao.account.login.presenter.LoginPresenter;
import com.transsion.xuanniao.account.login.view.BehaviorVerifyDialog;
import com.transsion.xuanniao.account.login.view.CountrySelectActivity;
import com.transsion.xuanniao.account.login.view.FrozenDialog;
import com.transsion.xuanniao.account.model.data.AccountRes;
import com.transsion.xuanniao.account.model.data.BehaviorRes;
import com.transsion.xuanniao.account.model.data.BehaviorVerifyRes;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;
import com.transsion.xuanniao.account.model.data.CountryData;
import com.transsion.xuanniao.account.model.data.LoginRes;
import com.transsion.xuanniao.account.model.data.PolicyRes;
import com.transsion.xuanniao.account.model.data.PrivacyAgreementMap;
import org.json.JSONObject;
import tech.palm.lib.athena.AthenaImpl;

public class LoginActivity
extends BaseActivity
implements ILoginView {
    public static final int GOOGLE_SIGN_IN = 9001;
    private int reqCC = 1101;
    private int reqLoginSuccess = 1102;
    private LoginPresenter presenter;
    private AccountInput accountInput;
    private BehaviorVerifyInput verifyInput;
    private CaptchaCodeInput captchaInput;
    private SmsCodeInput codeInput;
    private CheckBox agreementCheck;
    private ErrorView loginByCodeError;
    private boolean isMainProcess = false;
    private Button loginOrRegister;
    private ViewGroup privacyL;
    private ScrollView scrollView;
    private PalmAuthRequest palmAuthRequest;
    private boolean shouldShowEmailAssociation = false;
    private String verifyType = null;
    private BehaviorVerifyDialog verifyDialog;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.presenter = new LoginPresenter();
        this.presenter.attachView(this);
        this.presenter.setFinish(this.booleanExtra("isFinish"));
        if (CloudConfigRes.needRefresh((Context)this)) {
            this.presenter.getCloudConfig();
        }
        String authRequestId = this.getIntent().getStringExtra("auth_request");
        if (savedInstanceState != null && TextUtils.isEmpty((CharSequence)authRequestId)) {
            authRequestId = savedInstanceState.getString("auth_request", null);
        }
        this.palmAuthRequest = PalmAuthManager.getInstance((Context)this).getAuthRequest(authRequestId);
        this.mainProcess();
    }

    private void mainProcess() {
        long captchaLimit;
        long pwdLimit;
        this.setContentView(R.layout.xn_activity_login);
        this.isMainProcess = true;
        this.initActionBar();
        this.initNote();
        this.init();
        this.initInput();
        if (TeeManager.instance().isTeeEnable() && !TeeManager.instance().getIsKeyUploaded() && NetUtils.instance().isNetworkConnected((Context)this)) {
            this.presenter.applyKey("");
        }
        if ((pwdLimit = ClientPrefs.get((Context)this).getLoginPwdLimit()) > 0L) {
            this.presenter.showFivePwdLimit(pwdLimit);
        }
        if ((captchaLimit = ClientPrefs.get((Context)this).getCaptchaLoginLimit()) > 0L) {
            this.presenter.showCaptchaLimit(captchaLimit);
        }
        this.presenter.getCountriesFromCache();
    }

    private String getSource() {
        String source = this.stringExtra("source");
        if (TextUtils.isEmpty((CharSequence)source)) {
            source = "ExternalCall";
        }
        return source;
    }

    @SuppressLint(value={"StringFormatInvalid", "StringFormatMatches"})
    private void showSignOutTips(Context context) {
    }

    private void initActionBar() {
        ActionBar actionBar = this.getActionBar();
        actionBar.setDisplayOptions(16, 26);
        actionBar.setCustomView(R.layout.xn_action_bar);
        actionBar.setDisplayHomeAsUpEnabled(true);
        TextView title = (TextView)actionBar.getCustomView().findViewById(R.id.title);
        title.setText((CharSequence)"");
    }

    private void initNote() {
        String customizeApp = this.getString(R.string.sdk_lite_customize_app);
        TextView noteTitle = (TextView)this.findViewById(R.id.noteTitle);
        noteTitle.setText((CharSequence)OSUtils.toBrandId(this.getString(R.string.sdk_text_login, new Object[]{customizeApp})));
        TextView loginTips = (TextView)this.findViewById(R.id.tvLoginTips);
        loginTips.setText((CharSequence)this.getString(R.string.sdk_lite_customize_have_account, new Object[]{customizeApp}));
    }

    @SuppressLint(value={"StringFormatInvalid"})
    private void init() {
        this.scrollView = (ScrollView)this.findViewById(R.id.scrollView);
        this.loginOrRegister = (Button)this.findViewById(R.id.loginOrRegister);
        if (this.loginOrRegister != null) {
            this.loginOrRegister.setOnClickListener((View.OnClickListener)new LoginClick());
        }
        this.agreementCheck = (CheckBox)this.findViewById(R.id.agreementCheck);
        this.agreementCheck.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).enableAthena(true);
                    ClientPrefs prefs = ClientPrefs.get(LoginActivity.this.getContext());
                    AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).authorizeCl(prefs.getPrivacyVersion(), prefs.getUserAgreementVersion(), "", "", "");
                }
            }
        });
        this.findViewById(R.id.tvLoginHere).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    String customizeIntent = LoginActivity.this.getString(R.string.sdk_lite_customize_intent);
                    if (!TextUtils.isEmpty((CharSequence)customizeIntent)) {
                        Intent intent = new Intent();
                        if (customizeIntent.contains("/")) {
                            String[] splits = customizeIntent.split("/");
                            intent.setClassName(splits[0], splits[1]);
                        } else {
                            intent.setAction(customizeIntent);
                        }
                        LoginActivity.this.startActivity(intent);
                        LoginActivity.this.cancelAndFinish(true);
                    }
                }
                catch (Exception e) {
                    LogUtils.d(Log.getStackTraceString((Throwable)e));
                }
            }
        });
        this.privacyL = (ViewGroup)this.findViewById(R.id.privacyL);
        this.showAgreement();
        OverScrollDecorHelper.setUpOverScroll((ScrollView)this.scrollView);
    }

    @Override
    protected boolean isShouldHideKeyboard(View v, MotionEvent event) {
        return !(this.isClickView((View)this.agreementCheck, event) || this.captchaInput != null && this.isClickView((View)this.captchaInput.getEdit(), event) || this.accountInput != null && this.isClickView((View)this.accountInput.getEdit(), event) || this.codeInput != null && this.isClickView((View)this.codeInput.getEdit(), event)) && !this.isClickView((View)this.privacyL, event);
    }

    private void showAgreement() {
        TextView agreement = (TextView)this.findViewById(R.id.agreement);
        String userAgreement = this.getString(R.string.xn_user_agreement);
        String privacyPolicy = this.getString(R.string.xn_privacy_policy);
        String and = this.getString(R.string.xn_and);
        String agreementPolicy = this.getRS(R.string.xn_agreement_privacy, userAgreement, privacyPolicy);
        if (!this.languageRight(agreementPolicy, userAgreement, privacyPolicy)) {
            agreementPolicy = "I have read and agreed to the TECNO ID User Agreement and Privacy Policy";
            userAgreement = "User Agreement";
            privacyPolicy = "Privacy Policy";
        }
        agreementPolicy = OSUtils.toBrandId(agreementPolicy);
        SpannableString ss = new SpannableString((CharSequence)(agreementPolicy + " "));
        int start = agreementPolicy.toLowerCase().indexOf(userAgreement.toLowerCase());
        try {
            ss.setSpan((Object)new XNClickableSpan((Context)this, new XNClickableSpan.ClickListen(){

                @Override
                public void onClick(@NonNull View widget) {
                    AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).userAgreementCl();
                    String agreementUrl = PrivacyAgreementMap.getAgreementUrl(LanguageUtils.getLocalLanguage(LoginActivity.this.getContext()));
                    if (TextUtils.isEmpty((CharSequence)agreementUrl)) {
                        LoginActivity.this.presenter.getPolice(((LoginActivity)LoginActivity.this).presenter.TAG_USAGE);
                    } else {
                        WebViewActivity.startActivity((Context)LoginActivity.this, R.string.xn_user_agreement, OSUtils.toBrandUrl(agreementUrl));
                    }
                }
            }), start, start + userAgreement.length(), 33);
            start = agreementPolicy.toLowerCase().indexOf(privacyPolicy.toLowerCase());
            ss.setSpan((Object)new XNClickableSpan((Context)this, new XNClickableSpan.ClickListen(){

                @Override
                public void onClick(@NonNull View widget) {
                    AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).privacyPolicyCl();
                    String privacyUrl = PrivacyAgreementMap.getPrivacyUrl(LanguageUtils.getLocalLanguage(LoginActivity.this.getContext()));
                    if (TextUtils.isEmpty((CharSequence)privacyUrl)) {
                        LoginActivity.this.presenter.getPolice(((LoginActivity)LoginActivity.this).presenter.TAG_POLICY);
                    } else {
                        WebViewActivity.startActivity((Context)LoginActivity.this, R.string.xn_privacy_policy, OSUtils.toBrandUrl(privacyUrl));
                    }
                }
            }), start, start + privacyPolicy.length(), 33);
        }
        catch (Exception e) {
            LogUtils.d(Log.getStackTraceString((Throwable)e));
        }
        if (agreement != null) {
            agreement.setText((CharSequence)ss);
            agreement.setMovementMethod((MovementMethod)XNLinkMovementMethod.getInstance());
        }
    }

    private boolean languageRight(String agreementPolicy, String userAgreement, String privacyPolicy) {
        int start = agreementPolicy.toLowerCase().indexOf(userAgreement.toLowerCase());
        if (start == -1) {
            return false;
        }
        start = agreementPolicy.toLowerCase().indexOf(privacyPolicy.toLowerCase());
        return start != -1;
    }

    private void initInput() {
        this.accountInput = (AccountInput)this.findViewById(R.id.accountInput);
        this.captchaInput = (CaptchaCodeInput)this.findViewById(R.id.captchaInput);
        this.codeInput = (SmsCodeInput)this.findViewById(R.id.codeInput);
        this.loginByCodeError = (ErrorView)this.findViewById(R.id.loginByCodeError);
        this.accountInput.setOnlyPhoneNum();
        this.accountInput.addWatch(new LoginWatch());
        this.captchaInput.addWatch(new LoginWatch());
        this.codeInput.addWatch(new LoginWatch());
        this.codeInput.setSmsCodeListener(new SmsCodeInput.ISmsCodeListener(){

            @Override
            public void getCode() {
                LoginActivity.this.presenter.acquireCode(true);
            }

            @Override
            public void countFinish() {
                LoginActivity.this.codeEnable();
            }
        });
        this.codeInput.setEditFocus(new SmsCodeInput.EditFocus(){

            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && !TextUtils.isEmpty((CharSequence)LoginActivity.this.getVerificationCode())) {
                    LoginActivity.this.presenter.smsFillEnd();
                }
            }
        });
        this.accountInput.setInputListener(new AccountInput.IAccountInputListener(){

            @Override
            public void onSelectCc() {
                AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).modifyMccCl(LoginActivity.this.presenter.getCountryCode());
                Intent intent = new Intent((Context)LoginActivity.this, CountrySelectActivity.class);
                intent.putExtra("countryCode", LoginActivity.this.presenter.getCountryCode());
                intent.putExtra("countryName", LoginActivity.this.presenter.getCountryName());
                LoginActivity.this.startActivityForResult(intent, LoginActivity.this.reqCC);
                AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).modifyMccShow();
            }
        });
        this.captchaInput.setCaptchaListener(new CaptchaCodeInput.ICaptchaListener(){

            @Override
            public void onClick() {
                if (LoginActivity.this.presenter.isLoginByCode()) {
                    AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).picVerifyCl();
                }
                if (!LoginActivity.this.presenter.isShowCaptchaLimit()) {
                    LoginActivity.this.showWaitDialog(LoginActivity.this.getString(R.string.xn_loading));
                    LoginActivity.this.presenter.acquireCaptcha(null, true);
                }
            }
        });
        this.accountInput.setEditFocus(new AccountInput.EditFocus(){

            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                LoginActivity.this.presenter.setLoginStart(System.currentTimeMillis());
            }
        });
        this.codeInput.startByEnd(ClientPrefs.get((Context)this).getLoginCount());
        this.verifyInput = (BehaviorVerifyInput)this.findViewById(R.id.verifyInput);
        this.verifyInput.setVerifyListener(new BehaviorVerifyInput.VerifyListener(){

            @Override
            public void showVerifyDialog() {
                if (LoginActivity.this.verifyType == null) {
                    LoginActivity.this.verifyType = System.currentTimeMillis() % 2L == 0L ? "SINGLE_CLICK" : "SLIDE";
                }
                if (LoginActivity.this.verifyDialog == null) {
                    LoginActivity.this.verifyDialog = new BehaviorVerifyDialog();
                    LoginActivity.this.verifyDialog.setBehaviorListener(new BehaviorVerifyDialog.BehaviorListener(){

                        @Override
                        public void refreshClick() {
                            LoginActivity.this.presenter.getBehaviorData(LoginActivity.this.verifyType, false);
                            Bundle param = new Bundle();
                            param.putString("ti_s_type", LoginActivity.this.verifyType);
                            AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).trackAccountEvent("login_behavior_verify_refresh_cl", param);
                        }

                        @Override
                        public void startVerify(String data, String ticket, String resId) {
                            LoginActivity.this.presenter.verifyBehavior(LoginActivity.this.verifyType, data, ticket, resId);
                            Bundle param = new Bundle();
                            param.putString("ti_s_type", LoginActivity.this.verifyType);
                            AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).trackAccountEvent("login_behavior_verify_pop_cl", param);
                        }
                    });
                }
                LoginActivity.this.presenter.getBehaviorData(LoginActivity.this.verifyType, true);
                Bundle param = new Bundle();
                param.putString("ti_s_type", LoginActivity.this.verifyType);
                AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).trackAccountEvent("login_behavior_verify_touch_cl", param);
            }
        });
    }

    private void fillLastLoginReq() {
        int loginType = -1;
        String account = "";
        int codeType = 0;
        try {
            String lastLoginReq = ClientPrefs.get((Context)this).getLastLoginReq();
            if (lastLoginReq.length() > 0) {
                JSONObject jsonObject = new JSONObject(lastLoginReq);
                loginType = jsonObject.getInt("lt");
                if (loginType == 0) {
                    account = jsonObject.getString("ac");
                    codeType = jsonObject.getInt("ct");
                }
                AthenaImpl.getInstance((Context)this).loginShow(this.getSource(), AthenaUtils.loginRecord(loginType, account, codeType));
            } else {
                AthenaImpl.getInstance((Context)this).loginShow(this.getSource(), null);
            }
        }
        catch (Exception e) {
            return;
        }
        if (loginType > 0) {
            // empty if block
        }
        if (loginType == 0 && account.length() > 0 && account.contains("-") && !account.contains("@")) {
            String[] texts = account.split("-");
            this.presenter.setCountryCode(texts[0]);
            this.accountInput.setCc(this.presenter.getCountryCodeWithPlus());
            this.accountInput.setText(texts[1]);
        }
    }

    protected void onResume() {
        if (this.isMainProcess && this.accountInput != null && this.accountInput.getEdit().hasFocus() && this.accountInput.getType() == 2 && this.shouldShowEmailAssociation) {
            this.shouldShowEmailAssociation = false;
            this.accountInput.showEmailAssociation();
        }
        super.onResume();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.reqCC) {
            if (resultCode == -1) {
                this.presenter.setCountryCode(data.getStringExtra("key_cc"));
                if (this.presenter.getCountryData() != null) {
                    this.presenter.setCountryName(CountryData.getEnName(this.getContext(), data.getStringExtra("key_name"), this.presenter.getCountryData().countries));
                }
                AthenaImpl.getInstance((Context)this.getContext()).selectMccCl(this.presenter.getCountryCode());
                this.accountInput.setCc(this.presenter.getCountryCodeWithPlus());
                ClientPrefs prefs = ClientPrefs.get(this.getContext());
                prefs.setCountryCode(this.presenter.getCountryCode());
                prefs.setCountryName(this.presenter.getCountryName());
                prefs.save();
            }
        } else if (requestCode == 9001) {
            // empty if block
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.cancelAndFinish(true);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.clearCount();
            this.presenter.detachView();
        }
        if (this.codeInput != null) {
            this.codeInput.clearCount();
        }
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void showCaptcha(String captchaCode, String captchaBase64) {
        this.captchaInput.setImageBitmap(captchaBase64);
        if (TextUtils.isEmpty((CharSequence)captchaCode)) {
            this.captchaInput.setVisibility(0);
        } else {
            this.captchaInput.setVisibility(8);
        }
        this.verifyInput.setVisibility(8);
        if (this.presenter.isCodeNeedCaptcha()) {
            AthenaImpl.getInstance((Context)this.getContext()).picVerifyShow();
        }
        this.codeEnable();
        this.loginEnable();
    }

    @Override
    public void showCaptchaReduction() {
        this.captchaInput.setImageResource(R.drawable.xn_reduction);
    }

    @Override
    public String getAccount() {
        return this.accountInput.getText();
    }

    @Override
    public String getImageCaptcha() {
        return this.captchaInput.getText();
    }

    @Override
    public String getVerificationCode() {
        return this.codeInput.getText();
    }

    @Override
    public int getType() {
        return this.accountInput.getType();
    }

    @Override
    public void acquireCodeSuccess() {
        this.warning(this.getContext().getString(R.string.xn_sent));
        this.codeInput.clearCount();
        this.codeInput.startCount();
        this.codeInput.setGetCodeEnable(false);
        ClientPrefs prefs = ClientPrefs.get((Context)this);
        prefs.setLoginCount(System.currentTimeMillis());
        prefs.save();
    }

    @Override
    public void updateVerifyView() {
        if (this.verifyInput.getVisibility() == 0) {
            this.verifyInput.setState(0);
            this.loginEnable();
        } else {
            this.presenter.acquireCaptcha(null, true);
        }
    }

    @Override
    public void getBehaviorResult(final BehaviorRes behaviorRes, boolean showImage) {
        if (behaviorRes != null) {
            if (showImage) {
                this.verifyDialog.show(this);
                Bundle param = new Bundle();
                param.putString("ti_s_type", this.verifyType);
                AthenaImpl.getInstance((Context)this.getContext()).trackAccountEvent("login_behavior_verify_pop_show", param);
            }
            Glide.with((Context)this.getApplicationContext()).asBitmap().load(behaviorRes.bg).into((Target)new SimpleTarget<Bitmap>(){

                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    LoginActivity.this.verifyDialog.setData(behaviorRes, resource);
                }
            });
        } else {
            this.warning(this.getString(R.string.xn_net_unavailable));
            if (this.verifyDialog.isShowing()) {
                this.verifyDialog.setData(null, null);
            }
        }
    }

    @Override
    public void verifyBehaviorResult(BehaviorVerifyRes verifyRes, int code) {
        if (code == 0) {
            if (verifyRes.result) {
                this.verifyInput.setState(1);
                this.verifyDialog.dismiss();
                this.loginEnable();
            } else {
                this.verifyInput.setState(2);
                this.verifyDialog.resetWithError();
                this.presenter.getBehaviorData(this.verifyType, false);
            }
        } else if (code == 400102) {
            this.warning(this.getString(R.string.xn_behavior_over_limit));
            this.verifyDialog.dismiss();
        } else {
            this.warning(this.getString(R.string.xn_net_unavailable));
            this.verifyInput.setState(2);
            this.verifyDialog.resetWithError();
        }
        if (this.presenter.isLoginByCode()) {
            this.codeEnable();
        }
    }

    @Override
    public String getPwd() {
        return null;
    }

    @Override
    public void loginSuccess(String eventType, LoginRes result) {
        this.goNext(result);
        ClientPrefs prefs = ClientPrefs.get((Context)this);
        prefs.setCountryCode(this.presenter.getCountryCode());
        prefs.setCountryName(this.presenter.getCountryName());
        if (!OSUtils.isOldPalmID) {
            prefs.setHaveAgreeBrand(true);
        }
        prefs.save();
        SharedPreferences sp = this.getSharedPreferences(this.getPackageName(), 0);
        String extPPV = sp.getString("ext_privacy_policy_version", "");
        String extUAV = sp.getString("ext_user_agreement_version", "");
        String extDPV = sp.getString("ext_developer_policy_version", "");
        AthenaImpl.getInstance((Context)this).loginSuccess(prefs.getPrivacyVersion(), prefs.getUserAgreementVersion(), extPPV, extUAV, extDPV);
    }

    private void goNext(LoginRes loginRes) {
        this.isMainProcess = false;
        if (this.presenter.isFinish()) {
            this.setResult(-1);
            if (this.palmAuthRequest != null) {
                Bundle result = new Bundle();
                try {
                    if (loginRes.account != null) {
                        result.putString("user_info", new JSONObject().put("nickName", (Object)loginRes.account.nickname).put("userName", (Object)loginRes.account.username).put("avatarUrl", (Object)loginRes.account.avatarUrl).toString());
                        result.putString("linked_id", String.valueOf(loginRes.account.xuanniaoId.hashCode()));
                        result.putString("linked_pkg", this.getPackageName());
                        result.putString("linked_bd", OSUtils.getBrandId());
                    }
                    result.putString("token_info", new JSONObject().put("access_token", (Object)loginRes.token.accessToken).put("refresh_token", (Object)loginRes.token.refreshToken).put("open_id", (Object)(loginRes.account != null ? loginRes.account.openId : "")).toString());
                }
                catch (Exception e) {
                    LogUtils.d(Log.getStackTraceString((Throwable)e));
                }
                Bundle eparam = new Bundle();
                eparam.putString("appid", this.palmAuthRequest.getAuthParam().getAppid());
                eparam.putString("version", "1.2.0.13_12");
                eparam.putString("result", "success");
                new AthenaCust("sdk_auth_result", 7710).trackCommon(eparam, null).submit();
                this.palmAuthRequest.setResult(result);
                this.palmAuthRequest = null;
            }
        }
        this.finish();
    }

    public void cancelAndFinish(boolean finish) {
        if (this.palmAuthRequest != null) {
            this.palmAuthRequest.onCancel();
        }
        if (finish) {
            this.finish();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.cancelAndFinish(false);
    }

    @Override
    public void displayCaptchaCodeInput() {
        this.captchaInput.setVisibility(0);
        this.codeEnable();
        this.loginEnable();
    }

    @Override
    public void showAcquireCodeDayLimit() {
        new PromptDialog.Builder((Context)this, R.style.dialog_soft_input).setTitle((CharSequence)this.getString(R.string.xn_frequent_operation)).setMessage((CharSequence)this.getString(R.string.xn_limit_day)).setPositiveButton((CharSequence)this.getString(R.string.xn_confirm), null).show();
    }

    @Override
    public void showAcquireCodeMonthLimit() {
        new PromptDialog.Builder((Context)this, R.style.dialog_soft_input).setTitle((CharSequence)this.getString(R.string.xn_frequent_operation)).setMessage((CharSequence)this.getString(R.string.xn_limit_month)).setPositiveButton((CharSequence)this.getString(R.string.xn_confirm), null).show();
    }

    @Override
    public void showCodeError() {
        if (this.loginByCodeError != null && this.presenter.isLoginByCode()) {
            this.loginByCodeError.setVisibility(0);
            this.loginByCodeError.setErrorText(this.getString(R.string.xn_code_error));
        }
        this.codeInput.setError(true);
        this.captchaInput.setError(false);
    }

    @Override
    public void byCodeShowCaptchaError() {
        if (this.loginByCodeError != null && this.presenter.isLoginByCode()) {
            this.loginByCodeError.setVisibility(0);
            this.loginByCodeError.setErrorText(this.getString(R.string.xn_captcha_error));
        }
        this.codeInput.setError(false);
        this.captchaInput.setError(true);
    }

    @Override
    public void byPwdShowCaptchaError() {
    }

    @Override
    public void showPwdError() {
    }

    @Override
    public boolean isImageCaptchaVisible() {
        return this.captchaInput.getVisibility() == 0;
    }

    @Override
    public void getPoliceSuccess(PolicyRes result, String tag) {
        if (this.presenter.TAG_USAGE.equals(tag)) {
            WebViewActivity.startActivity((Context)this, R.string.xn_user_agreement, result.usageUrl);
        } else {
            WebViewActivity.startActivity((Context)this, R.string.xn_privacy_policy, result.privacyUrl);
        }
    }

    @Override
    public void saveAccount(AccountRes account) {
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid"})
    public void showFiveLimitError(boolean show, long millisUntilFinished) {
        if (show) {
            this.loginEnable();
        }
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid"})
    public void showCaptchaLimitError(boolean show, long millisUntilFinished) {
        if (show) {
            if (this.presenter.isLoginByCode() && this.presenter.isCodeNeedCaptcha() && this.loginByCodeError != null) {
                this.loginByCodeError.setErrorText(this.getRS(R.string.xn_frequent_count, FormatUtil.millisToM(millisUntilFinished)));
                this.loginByCodeError.setVisibility(0);
            }
        } else if (this.loginByCodeError != null) {
            this.loginByCodeError.setErrorText("");
            this.loginByCodeError.setVisibility(8);
        }
        this.codeEnable();
    }

    @Override
    public void showFrozenError(long endTime) {
        FrozenDialog.show(this, endTime);
        this.showPwdError();
    }

    @Override
    public void showCodeHelpTips() {
    }

    @Override
    public void showPhoneCode() {
        this.accountInput.setCc(this.presenter.getCountryCodeWithPlus());
        this.fillLastLoginReq();
    }

    private boolean isAgreementCheck() {
        if (!this.agreementCheck.isChecked()) {
            this.warning(this.getString(R.string.xn_read_agreement));
            return false;
        }
        return true;
    }

    public void onNewIntent(Intent intent) {
    }

    private void showError() {
        if (this.presenter.isLoginByCode() && this.loginByCodeError != null) {
            boolean showError = this.isError(R.id.captchaInput, this.getImageCaptcha(), this.loginByCodeError) || this.isError(R.id.codeInput, this.getVerificationCode(), this.loginByCodeError) || this.presenter.isCodeNeedCaptcha() && this.presenter.isShowCaptchaLimit();
            this.loginByCodeError.setVisibility(showError ? 0 : 8);
        }
    }

    private boolean isError(int key, String value, ErrorView errorView) {
        Object oError = errorView.getTag(key);
        return value.equals(oError);
    }

    private void codeEnable() {
        if (this.codeInput.isCounting() || this.presenter.isShowCaptchaLimit()) {
            this.codeInput.setGetCodeEnable(false);
        } else {
            boolean enable = this.getType() == 3 ? FormatUtils.checkRealPhone(this.getAccount()) : FormatUtil.checkEmail(this.getAccount());
            enable = this.captchaInput.getVisibility() == 0 ? this.getImageCaptcha().length() >= 4 && enable : enable && this.verifyInput.getState() == 1;
            this.codeInput.setGetCodeEnable(enable);
        }
    }

    private void loginEnable() {
        boolean enable = true;
        if (this.presenter.isLoginByCode()) {
            if (this.getType() == 3) {
                enable = FormatUtils.checkRealPhone(this.getAccount()) && this.getVerificationCode().length() >= 4;
            } else {
                boolean bl = enable = FormatUtil.checkEmail(this.getAccount()) && this.getVerificationCode().length() >= 4;
            }
            if (this.presenter.isCodeNeedCaptcha() && this.presenter.isShowCaptchaLimit()) {
                enable = false;
            }
        }
        if (this.captchaInput.getVisibility() == 0) {
            if (this.getImageCaptcha().length() < 4) {
                enable = false;
            }
        } else if (this.verifyInput.getState() != 1) {
            enable = false;
        }
        if (this.loginOrRegister != null) {
            this.loginOrRegister.setEnabled(enable);
        }
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.isMainProcess) {
            outState.putString("account", this.getAccount());
            outState.putString("verificationCode", this.getVerificationCode());
            this.presenter.saveState(outState);
            this.verifyInput.saveState(outState);
            this.captchaInput.saveState(outState);
            outState.putBoolean("isChecked", this.agreementCheck.isChecked());
            if (this.palmAuthRequest != null) {
                outState.putString("auth_request", this.palmAuthRequest.getAuthRequestId());
            }
        }
    }

    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.isMainProcess) {
            this.accountInput.setText(savedInstanceState.getString("account"));
            this.codeInput.setText(savedInstanceState.getString("verificationCode"));
            this.presenter.restoreState(savedInstanceState);
            this.verifyInput.restoreState(savedInstanceState);
            this.captchaInput.restoreState(savedInstanceState);
            this.agreementCheck.setChecked(savedInstanceState.getBoolean("isChecked"));
            this.showError();
            this.codeEnable();
            this.loginEnable();
        }
    }

    protected void onStop() {
        super.onStop();
        if (!this.isKeyboardShowing() && this.scrollView != null) {
            this.scrollView.clearFocus();
        }
        if (this.accountInput != null && this.accountInput.isShowEmailAssociation()) {
            this.shouldShowEmailAssociation = true;
            this.accountInput.hideEmailAssociation();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (this.accountInput != null) {
            this.accountInput.setCanShowPopView(hasFocus);
        }
    }

    class LoginClick
    extends CustomClickListener {
        LoginClick() {
        }

        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.loginOrRegister) {
                if (LoginActivity.this.presenter.isLoginByCode()) {
                    AthenaImpl.getInstance((Context)LoginActivity.this.getContext()).loginCl(LoginActivity.this.accountInput.isPhone(LoginActivity.this.accountInput.getText()) ? "Phone" : "Mail");
                }
                if (LoginActivity.this.isAgreementCheck()) {
                    LoginActivity.this.presenter.login();
                }
            }
        }

        @Override
        public void onFastClick(View v) {
        }
    }

    class LoginWatch
    implements TextWatcher {
        LoginWatch() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            LoginActivity.this.showError();
            LoginActivity.this.codeEnable();
            LoginActivity.this.loginEnable();
        }
    }
}

