/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.login.view;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;

public class PrivacyNoNetDialog {
    private PromptDialog promptDialog;
    private BaseActivity context;
    private PrivacyNoNetClick noNetClick;

    public PrivacyNoNetDialog(BaseActivity context, PrivacyNoNetClick noNetClick) {
        this.context = context;
        this.noNetClick = noNetClick;
    }

    @SuppressLint(value={"StringFormatInvalid", "StringFormatMatches"})
    public void show(final String url) {
        if (this.promptDialog == null) {
            this.promptDialog = new PromptDialog.Builder((Context)this.context, R.style.dialog_soft_input).setView(R.layout.xn_privacy_no_net_dialog).setTitle((CharSequence)this.context.getString(R.string.xn_no_net)).setPositiveButton((CharSequence)this.context.getString(R.string.xn_got_it), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (PrivacyNoNetDialog.this.noNetClick != null) {
                        PrivacyNoNetDialog.this.noNetClick.onPositiveClick();
                    }
                }
            }).setCanceledOnTouchOutside(false).show();
            TextView note = (TextView)this.promptDialog.findViewById(R.id.note);
            note.setText((CharSequence)this.context.getRS(R.string.xn_privacy_no_net, ""));
            TextView urlTextView = (TextView)this.promptDialog.findViewById(R.id.urlTextView);
            urlTextView.setText((CharSequence)url);
            urlTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        Uri uri = Uri.parse((String)url);
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        PrivacyNoNetDialog.this.context.startActivity(intent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            urlTextView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    ClipboardManager manager = (ClipboardManager)PrivacyNoNetDialog.this.context.getSystemService("clipboard");
                    ClipData clipData = ClipData.newPlainText((CharSequence)"url", (CharSequence)url);
                    manager.setPrimaryClip(clipData);
                    Toast toast = Toast.makeText((Context)PrivacyNoNetDialog.this.context.getApplicationContext(), (CharSequence)PrivacyNoNetDialog.this.context.getString(R.string.xn_link_copy), (int)1);
                    toast.setGravity(17, 0, 0);
                    toast.show();
                    return true;
                }
            });
        } else if (!this.promptDialog.isShowing()) {
            this.promptDialog.show();
        }
    }

    public boolean isShow() {
        if (this.promptDialog != null) {
            return this.promptDialog.isShowing();
        }
        return false;
    }

    public void dismiss() {
        if (this.promptDialog != null) {
            this.promptDialog.dismiss();
        }
    }

    public static interface PrivacyNoNetClick {
        public void onPositiveClick();
    }
}

