/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.model.data;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class CloudConfigRes
implements Serializable {
    public static final String UNIT_HOUR = "hour";
    public static final String UNIT_TIMES = "times";
    public static final int TYPE_CODE_REMAIN_TIME = 8;
    public static final int TYPE_SUPPORT_LIST = 14;
    public static final int TYPE_PRIVACY_UPDATE = 15;
    public static final int TYPE_CAPTURE_OPEN = 7;
    public String versionId;
    public String versionName;
    public long timeStamp;
    public long sysTime;
    public long validPeriod;
    public ArrayList<ConfigItem> cloudClientConfigs;

    public static long getValidPeriod(Context context) {
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty((CharSequence)ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = (CloudConfigRes)gson.fromJson(ss, CloudConfigRes.class);
            return config.validPeriod;
        }
        return 60000L;
    }

    public static int getCount(Context context) {
        ArrayList<ConfigItem> cloudClientConfigs = CloudConfigRes.getCloudClientConfigs(context);
        if (cloudClientConfigs != null) {
            for (int i = 0; i < cloudClientConfigs.size(); ++i) {
                if (8 != cloudClientConfigs.get((int)i).type) continue;
                if (cloudClientConfigs.get((int)i).configMap == null || !cloudClientConfigs.get((int)i).configMap.containsKey("remainTime")) break;
                return Integer.parseInt(String.valueOf(cloudClientConfigs.get((int)i).configMap.get("remainTime")));
            }
        }
        return 100;
    }

    private static ArrayList<ConfigItem> getCloudClientConfigs(Context context) {
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty((CharSequence)ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = (CloudConfigRes)gson.fromJson(ss, CloudConfigRes.class);
            return config.cloudClientConfigs;
        }
        return null;
    }

    public static boolean privacyNeedAgree(Context context) {
        ClientPrefs prefs = ClientPrefs.get(context);
        ConfigItem configItem = CloudConfigRes.getConfig(context, 15);
        if (configItem != null && configItem.configMap != null) {
            String privacyVersion = String.valueOf(configItem.configMap.get("privacyVersion"));
            String userAgreementVersion = String.valueOf(configItem.configMap.get("userAgreementVersion"));
            boolean privacyUpdate = CloudConfigRes.conversionVersion(privacyVersion) > CloudConfigRes.conversionVersion(prefs.getPrivacyVersion());
            boolean userAgreementUpdate = CloudConfigRes.conversionVersion(userAgreementVersion) > CloudConfigRes.conversionVersion(prefs.getUserAgreementVersion());
            return privacyUpdate || userAgreementUpdate;
        }
        return false;
    }

    private static ConfigItem getConfig(Context context, int type) {
        ArrayList<ConfigItem> cloudClientConfigs = CloudConfigRes.getCloudClientConfigs(context);
        if (cloudClientConfigs != null) {
            for (int i = 0; i < cloudClientConfigs.size(); ++i) {
                if (type != cloudClientConfigs.get((int)i).type) continue;
                return cloudClientConfigs.get(i);
            }
        }
        return null;
    }

    public static void privacyAgree(Context context) {
        ClientPrefs prefs = ClientPrefs.get(context);
        ConfigItem configItem = CloudConfigRes.getConfig(context, 15);
        if (configItem != null && configItem.configMap != null) {
            String privacyVersion = String.valueOf(configItem.configMap.get("privacyVersion"));
            String userAgreementVersion = String.valueOf(configItem.configMap.get("userAgreementVersion"));
            prefs.setPrivacyVersion(privacyVersion);
            prefs.setUserAgreementVersion(userAgreementVersion);
            prefs.save();
        }
    }

    public static String privacyVersion(Context context) {
        ClientPrefs prefs = ClientPrefs.get(context);
        ConfigItem configItem = CloudConfigRes.getConfig(context, 15);
        if (configItem != null && configItem.configMap != null) {
            return String.valueOf(configItem.configMap.get("privacyVersion"));
        }
        return "";
    }

    private static int conversionVersion(String version) {
        if (!TextUtils.isEmpty((CharSequence)version)) {
            try {
                return Integer.parseInt(version);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static boolean needRefresh(Context context) {
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty((CharSequence)ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = (CloudConfigRes)gson.fromJson(ss, CloudConfigRes.class);
            return System.currentTimeMillis() - config.timeStamp >= 86400000L;
        }
        return true;
    }

    public static String getVersion(Context context) {
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty((CharSequence)ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = (CloudConfigRes)gson.fromJson(ss, CloudConfigRes.class);
            return config.versionId;
        }
        return "";
    }

    public static boolean captureOpen(Context context) {
        ConfigItem configItem = CloudConfigRes.getConfig(context, 7);
        if (configItem != null && configItem.configMap != null && configItem.configMap.containsKey("capture-open")) {
            return "true".equals(configItem.configMap.get("capture-open"));
        }
        return false;
    }

    public static String support(Context context) {
        ConfigItem configItem = CloudConfigRes.getConfig(context, 14);
        if (configItem != null && configItem.configMap != null && configItem.configMap.containsKey("support")) {
            return String.valueOf(configItem.configMap.get("support")).replace(", Carlcare Account", "");
        }
        return "Hi Account,X Account";
    }

    public static class ConfigItem
    implements Serializable {
        public String configId;
        public String configName;
        public int type;
        public String typeName;
        public HashMap<String, Object> configMap;
    }

    public static class Condition
    implements Serializable {
        public int range;
        public String unit;
    }
}

