/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.model.data;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import com.transsion.xuanniao.account.comm.utils.Sha256Utils;
import com.transsion.xuanniao.account.model.data.BaseEncryptRes;
import java.io.Serializable;

public class EncryptRes
implements Serializable {
    public String responseData;
    public String responseSign;

    public boolean checkSign() {
        if (TextUtils.isEmpty((CharSequence)this.responseData) || TextUtils.isEmpty((CharSequence)this.responseSign)) {
            return false;
        }
        try {
            byte[] sha256 = Sha256Utils.getSHA256(RSAEncryptUtil.base64Decode(this.responseData));
            return RSAEncryptUtil.checkSignature(sha256, this.responseSign, "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC591VlH9xM+TZYuWM4WZnxKYryc6xrGWco+jDFRfMNyLmET3bcEPnaCkZNcuVxjFvofiXfN4yNXFFY7iSysLzZ5GdnvAwYne8ONRxJuX2ixvMYduBhaPj2AAfEHZ6H3yo2kV6q8CX3CGzmLkz8pDPia9wmafjXSxObaPFgOEF0GwIDAQAB");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String dataJson(CipherHelper cipherHelper) {
        try {
            if (cipherHelper != null) {
                byte[] data = cipherHelper.decrypt(RSAEncryptUtil.base64Decode(this.responseData));
                return new String(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public boolean isSafe(String json, String verifyId) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            Gson gson = new Gson();
            BaseEncryptRes base = (BaseEncryptRes)gson.fromJson(json, BaseEncryptRes.class);
            if (!TextUtils.isEmpty((CharSequence)base.verifyId)) {
                return TextUtils.equals((CharSequence)base.verifyId, (CharSequence)verifyId);
            }
        }
        return true;
    }
}

