package com.transsion.xuanniao.account.comm.net;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.gson.Gson;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.utils.AppUtils;
import com.transsion.xuanniao.account.comm.utils.FormatUtils;
import com.transsion.xuanniao.account.comm.utils.LanguageUtils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;

import tech.palm.lib.utils.CloudUtils;

/**
 * @Description:
 * @author： HuNan on 2020/5/19
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class Utils {
//    public static String getLanguage(Context context) {
//        String language = context.getString(R.string.xn_language);
//        if ("default".equals(language)) {
//
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
//                LocaleList locales = context.getResources().getConfiguration().getLocales();
//                Locale locale = locales.get(0);
//                language = locale.getLanguage();
//            } else {
//                language = Locale.getDefault().getLanguage();
//            }
//        }
//        return language;
//    }
    public static String getOsType(){
        return "1";
    }

    /**
     * 获取包名
     * @param context
     * @return
     */
    public static String getPackageName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(
                    context.getPackageName(), 0);
            return packageInfo.packageName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取应用版本名称
     * @param context
     * @return
     */
    public static int getVersionCode(Context context,String pkgName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(
                    pkgName, 0);
            return packageInfo.versionCode;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getVersionName(Context context,String pkgName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(
                    pkgName, 0);
            return packageInfo.versionName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 时区，与utc相差小时数
     * @return
     */
    public static String getTimeZone() {
        Calendar now = Calendar.getInstance();
        int offset = now.getTimeZone().getOffset(System.currentTimeMillis()) / 3600000;
        return String.valueOf(offset);
    }

    /**
     * 获取签名SHA1指纹
     * @param context
     * @param packageName
     * @return
     */
    public static String getSHA1Fingerprint(Context context, String packageName) {
        //获取包管理器
        PackageManager pm = context.getPackageManager();
        //返回包括在包中的签名信息
        int flags = PackageManager.GET_SIGNATURES;
        PackageInfo packageInfo = null;
        try {
            //获得包的所有内容信息类
            packageInfo = pm.getPackageInfo(packageName, flags);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (packageInfo == null) {
            Log.d("AidlUtil", "信息为 null, 包名 = " + packageName);
            return "";
        }
        //签名信息
        Signature[] signatures = packageInfo.signatures;
        byte[] cert = signatures[0].toByteArray();
        //将签名转换为字节数组流
        InputStream input = new ByteArrayInputStream(cert);
        //证书工厂类，这个类实现了出厂合格证算法的功能
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X509");
        } catch (CertificateException e) {
            e.printStackTrace();
        }
        //X509证书，X.509是一种非常通用的证书格式
        X509Certificate c = null;
        try {
            c = (X509Certificate) cf.generateCertificate(input);
        } catch (CertificateException e) {
            e.printStackTrace();
        }
        String hexString = null;
        try {
            //加密算法的类，这里的参数可以使MD4,MD5等加密算法
            MessageDigest md = MessageDigest.getInstance("SHA1");
            //获得公钥
            byte[] publicKey = md.digest(c.getEncoded());
            //字节到十六进制的格式转换
            hexString = byte2HexFormatted(publicKey);
        } catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        } catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        return hexString;
    }

    /**
     * 进行16进制转换
     * @param arr
     * @return
     */
    private static String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; i++) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1)
                h = "0" + h;
            if (l > 2)
                h = h.substring(l - 2, l);
            str.append(h.toUpperCase());
            if (i < (arr.length - 1))
                str.append(':');
        }
        return str.toString();
    }

    public static String params(Context context) {
        String pkgName = getPackageName(context);
        HashMap<String ,Object> map = new HashMap<>();
        map.put("gaid", DeviceInfo.getGAId());
        map.put("lang", LanguageUtils.getLocalLanguage(context));
        map.put("timezone",getTimeZone());
        map.put("osType",getOsType());
        map.put("pkgName",pkgName);
        map.put("channel","palmAppOrSdk");
        map.put("pkgSign",getPkgSign(context,pkgName));
        map.put("version", AppUtils.getVerName(context));
        map.put("deviceNo",getDeviceNo(context));
        map.put("deviceModel",getDeviceModel());
        map.put("isNotXuanNiao", true);
        map.put("oneId", "");
        map.put("privacyVersion", ClientPrefs.get(context).getPrivacyVersion());
        map.put("userAgreementVersion", ClientPrefs.get(context).getUserAgreementVersion());
        Gson gson = new Gson();
        return  Base64.encodeToString(gson.toJson(map).getBytes(), Base64.NO_WRAP);
    }

    private static String getDeviceModel() {
        return Build.MODEL + "-" + Build.BRAND;
    }

    private static String getDeviceNo(Context context) {
        ClientPrefs prefs = ClientPrefs.get(context);
        if (FormatUtils.isNotEmpty(prefs.getDeviceNo())){
            return prefs.getDeviceNo();
        }
        String deviceNo = UUID.randomUUID().toString();
        prefs.setDeviceNo(deviceNo);
        prefs.save();
        return deviceNo;
    }

    public static String getPkgSign(Context context,String pkgName){
        ClientPrefs prefs = ClientPrefs.get(context);
        String sign = prefs.getPkgSign();
        if (TextUtils.isEmpty(sign)){
            sign = getSHA1Fingerprint(context,pkgName);
            prefs.setPkgSign(sign);
            prefs.save();
        }

        return sign;
    }

    public static String base64Params(Context context) {
        String params = params(context);
        return Base64.encodeToString(params.getBytes(), Base64.NO_WRAP | Base64.NO_PADDING);
    }

    public static String getDeviceId(Context context){
        ClientPrefs prefs = ClientPrefs.get(context);
        String deviceId = prefs.getDeviceId();
        if (TextUtils.isEmpty(deviceId)){
            deviceId = CloudUtils.getDeviceInfo(context).getDeviceId();
            if (deviceId != null && deviceId.length() < 4){
                deviceId = "";
            }
            if (TextUtils.isEmpty(deviceId)){
                deviceId = DeviceInfo.getGAId();
            }
            if (TextUtils.isEmpty(deviceId)){
                deviceId = UUID.randomUUID().toString();
            }
            prefs.setDeviceId(deviceId);
            prefs.save();
        }

        return deviceId;
    }
}
