package com.transsion.xuanniao.account.comm.utils;

import android.content.Context;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.ViewTreeObserver;
import android.widget.TextView;

/**
 * @Description:
 * @author： 胡南 on 2021/4/23
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class TextViewUtils {
    /**
     * 设置textView结尾...后面显示的文字和颜色
     * @param context 上下文
     * @param textView textview
     * @param minLines 最少的行数
     * @param originText 原文本
     * @param endText 结尾文字
     */
    public static void toggleEllipsize(final Context context,
                                final TextView textView,
                                final int minLines,
                                final String originText,
                                final String endText) {
        if (TextUtils.isEmpty(originText)) {
            return;
        }
        textView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver
                .OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                int paddingLeft = textView.getPaddingLeft();
                int paddingRight = textView.getPaddingRight();
                TextPaint paint = textView.getPaint();
                float moreText = textView.getTextSize() * endText.length() * 1.2f;
                float availableTextWidth = (textView.getWidth() - paddingLeft - paddingRight) *
                        minLines - moreText;
                CharSequence ellipsizeStr = TextUtils.ellipsize(originText, paint,
                        availableTextWidth, TextUtils.TruncateAt.END);
                if (ellipsizeStr.length() < originText.length()) {
//                        CharSequence temp = ellipsizeStr + endText;
//                        SpannableStringBuilder ssb = new SpannableStringBuilder(temp);
//                        ssb.setSpan(new ForegroundColorSpan(context.getResources().getColor
//                                        (endColorID)),
//                                temp.length() - endText.length(), temp.length(),    Spannable.SPAN_INCLUSIVE_EXCLUSIVE);
                    textView.setText(ellipsizeStr);
                } else {
                    textView.setText(originText);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    textView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                } else {
                    textView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                }
            }
        });
    }

    public static void calculation(final Context context,
                                   final TextView textView,
                                   final int minLines,
                                   final String originText,
                                   final String endText,
                                   final Calculation calculation){
        textView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver
                .OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                int paddingLeft = textView.getPaddingLeft();
                int paddingRight = textView.getPaddingRight();
                TextPaint paint = textView.getPaint();
                float moreText = textView.getTextSize() * endText.length();
                float availableTextWidth = (textView.getWidth() - paddingLeft - paddingRight) *
                        minLines - moreText;
                CharSequence ellipsizeStr = TextUtils.ellipsize(originText, paint,
                        availableTextWidth, TextUtils.TruncateAt.END);

                if (ellipsizeStr.length() < originText.length()) {
                    calculation.onResult(ellipsizeStr.toString());
                } else {
                    calculation.onResult(originText);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    textView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                } else {
                    textView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                }
            }
        });
    }

    public interface Calculation{
        void onResult(String ellipsize);
    }
}