package com.transsion.xuanniao.account.login.view;

import android.content.Context;
import android.text.BidiFormatter;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.model.data.CountryData;

import java.util.ArrayList;

/**
 * @Description:
 * @author： 胡南 on 2021/4/25
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CountryListAdapter extends BaseAdapter {
    private ArrayList<CountryData.Country> countries;
    private Context context;
    private OnSelect onSelect;
    private boolean notShowCode = false;
    private boolean isCLick = false;
    private BidiFormatter bidiFormatter;
    public CountryListAdapter(Context context,ArrayList<CountryData.Country> data) {
        this.context = context;
        this.countries = data;
        bidiFormatter = BidiFormatter.getInstance();
    }

    public void setNotShowCode(boolean notShowCode) {
        this.notShowCode = notShowCode;
    }

    public void setCountries(ArrayList<CountryData.Country> data) {
        String name = getSelectedName();  // 先获取选中项
        countries = new ArrayList<>();
        countries.addAll(data);
        setSelected(null,name);
        notifyDataSetChanged();
    }

    private String getSelectedName() {
        if (countries != null) {
            for (int i = 0; i < countries.size(); i++) {
                if (countries.get(i).isSelected) {
                    return countries.get(i).country;
                }
            }
        }
        return null;
    }

    @Override
    public int getCount() {
        if (countries != null) {
            return countries.size();
        }
        return 0;
    }

    @Override
    public Object getItem(int position) {
        if (countries != null) {
            return countries.get(position);
        }
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from(context).inflate(R.layout.xn_item_country, null, false);
            Holder holder = new Holder();
            holder.name = convertView.findViewById(R.id.name);
            holder.code = convertView.findViewById(R.id.code);
            holder.radio = convertView.findViewById(R.id.radio);
            holder.content = convertView.findViewById(R.id.content);
            convertView.setTag(holder);
        }
        Holder holder = (Holder) convertView.getTag();
        CountryData.Country country = countries.get(position);
        holder.name.setText(country.displayName);
        if (notShowCode) {
            holder.code.setVisibility(View.INVISIBLE);
        } else {
            holder.code.setText(bidiFormatter.unicodeWrap("+" + country.code, TextDirectionHeuristics.LTR));
            holder.code.setVisibility(View.VISIBLE);
        }

//        holder.content.setBackgroundColor(context.getColor((country.isSelected && isCLick) ? R.color.xn_list_selected : R.color.xn_page_bg));
        holder.radio.setChecked(country.isSelected);
        holder.radio.setTag(position);
        holder.radio.setOnClickListener(v -> setSelected(position));
        return convertView;
    }

    public void setSelected(int index) {
        if (!countries.get(index).isSelected) {
            for (int i = 0; i < countries.size(); i++) {
                countries.get(i).isSelected = index == i;
            }
            isCLick = true;
            notifyDataSetChanged();
        }
        if (onSelect != null) {
            onSelect.select(index);
        }
    }

    public void setSelected(String code,String name) {
        if (TextUtils.isEmpty(code) && TextUtils.isEmpty(name)) {
            return;
        }
        if (TextUtils.isEmpty(name)){
            for (int i = 0; i < countries.size(); i++) {
                countries.get(i).isSelected = code.equals(countries.get(i).code);
//                if (countries.get(i).isSelected){
//                    break;
//                }
            }
        }else {
            String enName = CountryData.getEnName(context, name, countries);
            if (!TextUtils.isEmpty(enName)){
                name = enName;
            }

            for (int i = 0; i < countries.size(); i++) {
                countries.get(i).isSelected = name.equals(countries.get(i).country);
            }
        }
    }

    public void setOnSelect(OnSelect onSelect) {
        this.onSelect = onSelect;
    }

    public int getSelectIndex() {
        for (int i = 0; i < countries.size(); i++) {
            if (countries.get(i).isSelected) {
                return i;
            }
        }
        return 0;
    }

    class Holder {
        public TextView name;
        public TextView code;
        public RadioButton radio;
        public RelativeLayout content;
    }

    public interface OnSelect {
        void select(int position);
    }
}