package com.transsion.xuanniao.account.model.data;

import android.content.Context;
import android.util.Base64;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;

import java.io.Serializable;
import java.util.HashMap;

/**
 * @Description:
 * @author： 胡南 on 2021/5/20
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CommReq implements Serializable {
    public String data;
    public String requestKey;
    public String requestSign;
    public String keyId;
    public long signTime;

    public static Object generateReq(Context context,CipherHelper cipherHelper, Object params) throws Exception {
        if (TeeManager.instance().isTeeEnable()) {
            Gson gson = new Gson();
            CommReq req = new CommReq();
            req.signTime = System.currentTimeMillis() + ClientPrefs.get(context).getTimeDiff();
            HashMap<String, Object> map = gson.fromJson(gson.toJson(params), HashMap.class);
            map.put("signTime", String.valueOf(req.signTime));
            byte[] encrypt = cipherHelper.encrypt(gson.toJson(map).getBytes());
            req.data = encrypt != null ? Base64.encodeToString(encrypt, 0) : null;
            req.requestKey = RSAEncryptUtil.encrypt(cipherHelper.requestKey(), Key.PUBLIC_KEY);
            req.keyId = TeeManager.instance().genKeyId(context);
            req.requestSign = TeeManager.instance().sign(context, encrypt);
//            LogUtils.d("requestKey:"+RSAEncryptUtil.base64Encode(cipherHelper.requestKey()));
//            LogUtils.d("encrypt:"+(encrypt == null ? "null":"" + encrypt.length));
//            LogUtils.d("data:"+req.data);
//            LogUtils.d("requestSign:"+req.requestSign);
//            LogUtils.d("keyId:"+req.keyId);
            return req;
        }  else {
            return params;
        }
    }
}